/***********************************************************

File Name :
	steimlib.h

Programmer:
	Phil Maechling

Description:
	This is the CIT version of Joe Steims steimlib.

Creation Date:
	30 January 1996

Modification History:


Usage Notes:


**********************************************************/

  /*
   *    File:
   *            steimlib.h  -   header file for library of steim compression
   *                            functions "steimlib.c"
   */

#ifndef steimlib_H
#define steimlib_H

#ifdef __cplusplus
extern "C"
{

LONG endianflip (LONG e) ;

SHORT swapb (SHORT e) ;

SHORT compress_frame (ccptype ccp,  SHORT difference,  
		      SHORT level,  SHORT reserve,  SHORT flip) ;

void fix (ccptype ccp) ;

void clear_compression (ccptype ccp,  SHORT level) ;

void clear_running_compression (ccptype ccp,  SHORT level,
				int samplast,int sampnextlast) ;

ccptype init_compression (SHORT level) ;

LONG final_sample (ccptype ccp) ;

SHORT peek_threshold_avail (ccptype ccp) ;

SHORT peek_contents (ccptype ccp) ;

LONG frames (ccptype ccp) ;

SHORT blocks_padded (ccptype ccp) ;

SHORT peek_write (ccptype ccp,  LONG samples[], SHORT numwrite) ;

void insert_constant (cfp framep,  LONG sample,  SHORT level,  
			SHORT flip,  SHORT blockindex, BOOLEAN force) ;

adptype init_adaptivity (SHORT diff, SHORT fpt, SHORT fpp, 
			SHORT level, SHORT flip) ;

SHORT compress_adaptively (adptype adp) ;

SHORT compress_generic_record (gdptype gdp,  SHORT firstframe) ;


LONG generic_record_samples (gdptype gdp) ;

void clear_generic_compression (gdptype gdp, SHORT framesreserved) ;

gdptype init_generic_compression (SHORT diff, SHORT fpt, SHORT fpp, 
				  SHORT level, SHORT flip, 
				  generic_data_record *gdr) ;
}
#else



LONG endianflip (LONG e) ;

SHORT swapb (SHORT e) ;

SHORT compress_frame (ccptype ccp,  SHORT difference,  
		      SHORT level,  SHORT reserve,  SHORT flip) ;

void fix (ccptype ccp) ;

void clear_compression (ccptype ccp,  SHORT level) ;

void clear_running_compression (ccptype ccp,  SHORT level,
				int samplast,int sampnextlast) ;

ccptype init_compression (SHORT level) ;

LONG final_sample (ccptype ccp) ;

SHORT peek_threshold_avail (ccptype ccp) ;

SHORT peek_contents (ccptype ccp) ;

LONG frames (ccptype ccp) ;

SHORT blocks_padded (ccptype ccp) ;

SHORT peek_write (ccptype ccp,  LONG samples[], SHORT numwrite) ;

void insert_constant (cfp framep,  LONG sample,  SHORT level,  
			SHORT flip,  SHORT blockindex, BOOLEAN force) ;

adptype init_adaptivity (SHORT diff, SHORT fpt, SHORT fpp, 
			SHORT level, SHORT flip) ;

SHORT compress_adaptively (adptype adp) ;

SHORT compress_generic_record (gdptype gdp,  SHORT firstframe) ;

LONG generic_record_samples (gdptype gdp) ;

void clear_generic_compression (gdptype gdp, SHORT framesreserved) ;

gdptype init_generic_compression (SHORT diff, SHORT fpt, SHORT fpp, 
				  SHORT level, SHORT flip, 
				  generic_data_record *gdr) ;

#endif
#endif
