/***********************************************************

File Name :
	status.h

Programmer:
	Phil Maechling

Description:
	This is the declaration for the status class. It 
	manipulates the status messages.

Limitations or Warnings:


Creation Date:
	28 March 1995

Modification History:

**********************************************************/
#ifndef status_H
#define status_H

#include <iostream.h>
#include "basics.h" // K2 data structures and definitions
#include "k2defs.h"
#include "kff.h"



//--------------------------------------------------------//
// STATUS INFO
//--------------------------------------------------------//

typedef struct STATUS_INFO STATUS_INFO;
class CStatusInfo : public STATUS_INFO
{
   public:
      CStatusInfo(STATUS_INFO *p = NULL)
         { if (p) *(STATUS_INFO *)this = *p; }
      void SetData(STATUS_INFO *p)
         { if (p) *(STATUS_INFO *)this = *p; }

      WORD GetSerialNumber(void) { return serialNumber; }
      DWORD GetTime(void) { return systemTime; }
      const char *GetClockSource(void);
      const char *GetHardwareStatus(void); 
      const char *GetBatteryStatus(void);
      const char *GetDriveStatus(int drive);
      const char *GetRecorderID(void)
         { return stnID; }

      WORD GetEvents(void) { return events; }
      WORD GetRecordingErrors(void) { return recordingErrors; }
      BOOL IsAcqOn(void) { return (triggerStatus & 0x01); }
      BOOL IsTriggered(void) { return (triggerStatus & 0x02); }
      BOOL IsKeyboardTriggered(void)
         { return (triggerStatus & 0x04); }
      BOOL IsAlarmTriggered(void)
         { return (triggerStatus & 0x08); }
      BOOL IsExternalTriggered(void)
         { return (triggerStatus & 0x10); }
};

#endif
