/***********************************************************

File Name :
	sockctrl.h

Programmer:
	Phil Maechling

Description:
	This is the class declaration for the sockctrl class.
	It is a simple class which can open and write to a socket.

Limitations or Warnings:


Creation Date:
	29 January 1996

Modification History:

**********************************************************/
#ifndef sockctrl_H
#define sockctrl_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <iostream.h>
#include <string.h>

#include "basics.h"
#include "packet.h"
#include "qpacket.h"
#include "config.h"

class SocketControl 
{
      
   public:

      SocketControl(); 
      ~SocketControl();


      int  OpenSocket(char* hostname,int port);
      int  CloseSocket();
      int  Send(QPacket& packet);

   private:

//      struct q512_port_description_type q512_port;

      int fd;
      struct sockaddr_in sin;
      struct  hostent *hp;
      struct servent *sp;
};

#endif
