/***********************************************************

File Name :
	sockctrl.C

Programmer:
	Phil Maechling

Description:
	This is the class declaration for the sockctrl class.
	It is a simple class which can open and write to a socket.

Limitations or Warnings:


Creation Date:
	29 January 1996

Modification History:

**********************************************************/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>


#include <iostream.h>
#include <string.h>
#include <errno.h>

#include "basics.h"
#include "packet.h"
#include "sockctrl.h"

//*****************************************************************
// Constructor
//*****************************************************************

SocketControl::SocketControl()
{


 
}

//*****************************************************************
// Destructor
//*****************************************************************

SocketControl::~SocketControl()
{



}

//*****************************************************************
// Open socket routine
//*****************************************************************

int SocketControl::OpenSocket(char* hostname,int sock_port)
{

  if ( (hp = gethostbyname(hostname)) == 0) 
  {
    cout << "Unable to get host number from name " << hostname << endl;
    return(FAILURE);
  }

  memset((void *)&sin,0,sizeof(sin));
  memcpy((void *)&sin.sin_addr, (void *)hp->h_addr, hp->h_length);
  sin.sin_family = AF_INET;
  sin.sin_port = sock_port;

  if ( (fd = socket(AF_INET,SOCK_STREAM,0)) == FAILURE) 
  {
    cout <<" Socket call failed for " << hostname << " : " 
      << sock_port << endl; 
            return(FAILURE);
  }

  int optval = 1;
  if (setsockopt(fd,SOL_SOCKET,SO_KEEPALIVE,(char *)&optval,sizeof(int)) < 0) 
  {
    cout << "Unable to set SO_KEEPALIVE for " << hostname << " : " << 
      sock_port << endl;
    close(fd);
    return(FAILURE);
  }

  if (connect(fd,(struct sockaddr *)&sin,sizeof(sin)) == FAILURE) 
  {
    cout << "Connect call failed for " << hostname << " : " 
      << sock_port << endl;
    close(fd);
    return(FAILURE);
  }
  return (SUCCESS);
}


//*****************************************************************
// Close Socket
//*****************************************************************

int SocketControl::CloseSocket()
{
  close(fd); 
  return(SUCCESS);
}

//*****************************************************************
// Send Packet Routine
//*****************************************************************

int SocketControl::Send(QPacket& packet)
{
  int totalchars;
  int charnum;


  BYTE workbuf[550]; // A little more than the 523 needed
  BYTE outbuf[1000]; // worst case is every byte stuffed about 1000
  BYTE thischar;


  for (charnum=0;charnum<523;charnum++)
  {
    workbuf[charnum] = packet.GetAt(charnum);
  }

// Move the Nak and SOH (which don't get byte stuffed )

  totalchars = 0;
  charnum    = 0;
  outbuf[totalchars] = workbuf[charnum];
  ++totalchars;
  ++charnum;
  outbuf[totalchars] = workbuf[charnum];
  ++totalchars;

//  Byte Stuff the output buffer

  for(charnum=2;charnum<522;charnum++)
  {
    thischar = workbuf[charnum];
    if ( (thischar == DLE) || (thischar == NAK) || (thischar == ETX) )
    {
      outbuf[totalchars]=DLE;
      ++totalchars;
    }  
    outbuf[totalchars] = thischar; 
    ++totalchars;
  }

  // Insert the last ETX character

  thischar = workbuf[charnum];
  outbuf[totalchars] = thischar;
  ++totalchars;

  while ((charnum=send(fd,(char *)outbuf,totalchars,0)) != totalchars)
  {
    if (errno == EINTR)
    {
       continue;
    }
    cout << "Error writing to socket " <<endl;
//
// << q512_port.host_name << " : " 
//    << q512_port.port_number << endl;
//

    close(fd);
    return(FAILURE);
   }

}
