/***********************************************************

File Name :
	qpacket.h

Programmer:
	Phil Maechling

Description:
	This is the class definition for the quanterra (or shear)
	packet class.

Limitations or Warnings:


Creation Date:
	31 January 1996

Modification History:

**********************************************************/
#ifndef qpacket_H
#define qpacket_H

#include <stdio.h>
#include <iostream.h>
#include "cba.h"
#include "jsteim.h"

//*******************************************************

#define SHEAR_SEQ_MODULUS 8
#define SHEAR_COLD_START_SEQ 8

#define Q512_PACKET_SIZE 523
#define CURRENT_CENTURY 1900

#define SOH 0x01
#define ETX 0x03
#define DLE 0x10
#define NAK 0x15 /* Shear refers to this as SYN, but aka it is a NAK  */
#define ESC 0x1b

#define CRC_POLYNOMIAL                  0x56070368L
static  unsigned long   crc_table [256];        /* precalculated CRC-table */

static  int link_level_seq_no;


class QPacket : public CByteArray
{
   public:

      QPacket(CByteArray *pInputPacket=NULL); // constructor
      ~QPacket();

      // Data access
      void SetDataAt(int nIndex, BYTE data);

      BYTE GetDataAt(int nIndex);

      // Get a pointer

      BYTE *GetDataPointerAt(int nIndex);

      // Header access


      void SetHeaderTrailer()
         { SetAt(0,SOH),
           SetAt(1,NAK),
           SetAt(3,0x00),    // Control byte
           SetAt(4,0x00),    // 4 Header bytes = 0001
           SetAt(5,0x00),    // 
           SetAt(6,0x00),    // 
           SetAt(7,0x01),    //
           SetAt(8,0x01),    // Frame type = Data Packet 
           SetAt(11,0x00),   // State of Health = 0x22
           SetAt(18,0x00),   // Time Mark top byte
           SetAt(19,0x01),   // Time mark always for sample 1
           SetAt(24,0x00),   // Clock offset top byte = 00
           SetAt(25,0x00),   // Clock Offset Low byte
           SetAt(29,0x00),   // Set Spare = 00
           SetAt(522,ETX); }

      void SetLinkSeqNo();

      void SetComponent(int comp_num);

      void SetStream(int stream_num);

      void SetStationName(char* sta_nam);

      void SetFirstWordOfData(int fdata);

      void SetTotalSamples(int tsamples);

      void SetDataRate(int rate);

      void SetMilliseconds(int msecs);

      void SetTime(int yr, int mnth, int day,
		   int hr, int minute, int sec);

      void SetDataSequenceNumber(unsigned int);

      void SetData(gdptype data);

      void SetChecksum(); 
      void SetCRC();

   private:

      void initialize_crc();
};

#endif
