/***********************************************************

File Name :
	packet.h

Programmer:
	Phil Maechling

Description:
	This is the class definition for the packet class.
	This class was ported from the Kinemetrics code to
	run on the Unix machine.

Limitations or Warnings:


Creation Date:
	29 March 1995

Modification History:

**********************************************************/
#ifndef PACKET_H
#define PACKET_H

#include <stdio.h>
#include <iostream.h>
#include "cba.h"

/*
   PKTFRAME character (1 byte)
   PACKET_HDR (8 bytes)
   PACKET_HDR checksum (1 byte)
   Data: (N bytes)
     Replace all instances of PKTESC char with PKTESC ESC_EQUIVALENT
     Replace all instances of PKTFRAME char with PKTESC END_EQUIVALENT
   Data Check Word (2 bytes)
   PKTFRAME character (1 byte)

   Three PKTESC bytes followed by CR aborts block mode.
*/

/*-------------------------------------------------------*/

/* Packet type codes */
#define PKC_MSG            0x00
#define PKC_GETPARMS       0x01
#define PKC_SETPARMS       0x02
#define PKC_GETSTATUS      0x03
#define PKC_GETDIR         0x04
#define PKC_GETFILE        0x05
#define PKC_DELETEFILE     0x06
#define PKC_UNDELETEFILE   0x07
#define PKC_PING           0x08
#define PKC_SETALARM       0x09
#define PKC_ACQSTART       0x0A
#define PKC_ACQSTOP        0x0B
#define PKC_OPENDIR        0x0C
#define PKC_CLOSEDIR       0x0D
#define PKC_OPENFILE       0x0E
#define PKC_CLOSEFILE      0x0F
#define PKC_PACK           0x10
#define PKC_FORMAT         0x11
#define PKC_RMDIR          0x12
#define PKC_MKDIR          0x13
#define PKC_CHDIR          0x14
#define PKC_FT             0x15
#define PKC_GETDIRNAME     0x16
#define PKC_RESETALARM     0x17
#define PKC_TRIGGER        0x18
#define PKC_DETRIGGER      0x19
#define PKC_TIME           0x1A
#define PKC_GETEVENTSUMMARY   0x1B
#define PKC_PASSWORD       0x1C
#define PKC_PKTESC         0x5C /* same as PKTESC code, do not use */

#define PKC_STRCTRL        0x20 // Stream ctrl: start/stop/continue/reset
#define PKC_STRSEND        0x21 // send streaming packet request
#define PKC_PKTDEBUG       0x70 // New: for debugging
 
#define PKR_ACK            0x80
#define PKR_PARMS          0x81
#define PKR_STATUS         0x83
#define PKR_DIR            0x84
#define PKR_FILE           0x85
#define PKR_PING           0x88
#define PKR_STRDATA        0X8A // Stream data packet
#define PKR_STRRQDATA      0X8b // Stream data packet request response
#define PKR_DIRNAME        0x96

#define PKR_EVENT_SUMMARY  0x9B

#define PKR_PKTFRAME       0xC0 /* same as PKTFRAME code, do not use */

/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/* Design Note: if you change the codes for PKTFRAME and PKTESC,
   be sure that no Packet Type code has the same codes as
   PKTESC and PKTFRAME
*/
#define PKTESC '\\' /* 0x5c, 92d */
#define PKTFRAME 0xC0 /* 192d */
#define ESC_EQUIVALENT 0xDC
#define END_EQUIVALENT 0xDD

#define PACKET_MAX_SIZE 2048+3     /* max. # of bytes in packet */
				   /* including 3 byte checksum */
#define PACKET_MAX_DATALENGTH 2040 /* max # of data bytes */
#define PACKET_HDR_SIZE 8          /* 8 bytes */

// Byte offsets of struct PACKET_HDR members
// NOTE: if this is changed, be sure to change the Getxxx, Setxxx
// functions also!

#define OFFSET_TYPECODE 0  // byte offset 0
#define OFFSET_SEQNO 1
#define OFFSET_SOURCE 2
#define OFFSET_DESTINATION 4
#define OFFSET_DATALENGTH 6


struct PACKET_HDR {
   unsigned char typeCode; // packet type  byte #0
   unsigned char seqNo; // byte #1
   unsigned char sourceHi; // byte #2
   unsigned char sourceLo; // byte #3
   unsigned char destHi; // byte# 4
   unsigned char destLo; // Byte #5
   unsigned char dataLengthHi; // byte #6
   unsigned char dataLengthLo; // byte #7
};

/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

#define WM_PACKET WM_USER+100 /* packet message */
#define WM_REFRESH WM_USER+101 /* refresh message */

// Packet class
// A "packet" consists of an 8 byte header, followed by a checksum
// byte of the header, n data bytes, and a checksum word.
class CPacket : public CByteArray
{

   private:
      BYTE CalcHeaderChecksum(void);
      WORD CalcDataChecksum(void);

   public:
      CPacket(CByteArray *pInputPacket=NULL); // constructor
      CPacket(BYTE typeCode, WORD source, WORD destination);
      static CPacket *New(CByteArray *pInputPacket=NULL);
      static CPacket *New(BYTE typeCode, WORD source, WORD destination);

      // Data access
      void SetDataAt(int nIndex, BYTE data);
      void SetDataAt(int nIndex, CByteArray& array);
      void SetDataAt(int nIndex, BYTE *pData, int nBytes);
      BYTE GetDataAt(int nIndex);
      void GetData(CByteArray *array);
      BYTE *GetDataPointerAt(int nIndex);
      BYTE GetAt(int nIndex) { return CByteArray::GetAt(nIndex); }

      // Header access
      void SetTypeCode(BYTE typeCode)
         { SetAt(OFFSET_TYPECODE, typeCode); }
      BYTE GetTypeCode(void)
         { return GetAt(OFFSET_TYPECODE); }

      void SetSeqNo(BYTE seqNo)
         { SetAt(OFFSET_SEQNO, seqNo); }
      BYTE GetSeqNo(void)
         { return GetAt(OFFSET_SEQNO); }

      void SetSource(WORD source);
      WORD GetSource(void)
         { return (((WORD)GetAt(OFFSET_SOURCE)) << 8)
            + GetAt(OFFSET_SOURCE+1); }

      void SetDestination(WORD dest);
      WORD GetDestination(void)
         { return (((WORD)GetAt(OFFSET_DESTINATION)) << 8)
            + GetAt(OFFSET_DESTINATION+1); }

      void SetDataLength(WORD dataLength);
      WORD GetDataLength(void)
         { return (((WORD)GetAt(OFFSET_DATALENGTH)) << 8)
            + GetAt(OFFSET_DATALENGTH+1); }

      void SetDataString(char *setstring);
      void GetDataString(char *outstring);

      WORD GetPacketSize(void) /* packet size, includes 3 checksum bytes */
         { return GetSize(); }

      // Checksum
      BOOL Verify(void); // returns TRUE if the packet is OK
      void SetHeaderChecksum(void); 
      BYTE GetHeaderChecksum(void)
         { return GetAt(PACKET_HDR_SIZE); }

      void SetDataChecksum(void); // and inserts in the array
      WORD GetDataChecksum(void);
};

#endif
