/***********************************************************

File Name :
	kpr.C

Programmer:
	Phil Maechling

Description:
	K2 Port Reader

	This routine identifies which port to read to receive
	incoming K2 packets.

	It then begins to read the port and passes packet on to the
	packet processor.

Creation Date:
	27 January 1996

Modification History:


Usage Notes:


**********************************************************/
#include "k2rt.h"
#include "kpr.h"

extern int debug;

//**************************************************************
// Constructor
//**************************************************************

K2_Port_Reader::K2_Port_Reader()
{

};

//**************************************************************
// Destructor
//**************************************************************

K2_Port_Reader::~K2_Port_Reader()
{

};

//**************************************************************
// Main packet reading routine
//**************************************************************

K2_Port_Reader::get_next_valid_packet(CCommControl& k2_port,
				      CPacket& valid_packet)
{
  int searching_for_packet = TRUE;

  while(searching_for_packet)
  {
    // This port will time out if nothing is received within 5 seconds

    if (k2_port.ReadComm())
    {
       valid_packet = k2_port.LastPacket();
       searching_for_packet = FALSE;
    }
    else
    {
      if (debug == TRUE)
      {
        cout << "Serial Port Time Out" << endl;
      }
    }
  }

  return(SUCCESS);

}
