/***********************************************************

File Name :
	kff.h

Programmer:
	Phil Maechling

Description:
	This is the CIT Unix version of Kinemetrics kff.h file
	This contains structure definitions for the kff tag
	which is used at the start of kinemetrics format files.

Limitations or Warnings:


Creation Date:
	28 March 1998

Modification History:

**********************************************************/
#ifndef kff_H
#define kff_H

#include "basics.h"
#include "k2sizes.h"


#define KFF_BYTE_ORDER 0 /* 0=INTEL (LSB first) , 1 = MOTOROLA (MSB first) */
#define KFF_VERSION 1
#define KFF_SYNC_CHAR 'K'

WORD Checksum(BYTE *data, WORD length);

/* TAG. Separates and identifies structures */
struct KFF_TAG {
   BYTE sync; /* sync character 'K' */
   BYTE byteOrder; /* = 0 for LSB first (INTEL), 1 for MSB first (MOTOROLA) */
   BYTE version; /* File format version; KFF_VERSION */
   BYTE instrumentType; /* instrument type code */
   DWORD type; /* structure type code */
   WORD length; /* structure size in bytes */
   WORD dataLength; /* # of data bytes following the structure */
   WORD id; /* unique instrument id (e.g. serial number); used for multi-instrument files */
   WORD checksum; /* 16 bit checksum of structure + data */
};

//--------------------------------------------------------//
// KFF Structure Tag Object
typedef struct KFF_TAG KFF_TAG;

class CKFFTag : public KFF_TAG
{
   public:
      BOOL IsValid(void) { return (sync == KFF_SYNC_CHAR); }
      BYTE GetInstrumentType(void) { return instrumentType; }
      BYTE GetVersion(void) { return version; }
      BYTE GetByteOrder(void) { return byteOrder; }
      DWORD GetType(void)
         { return type; }
      WORD GetLength(void)
         { return length; }
      WORD GetDataLength(void)
         { return dataLength; }
      WORD GetInstrumentID(void)
         { return id; }
      WORD GetChecksum(void)
         { return checksum; }
};

//--------------------------------------------------------//
/* STRUCTURE TYPE CODES */
#define KFF_K2_HDR 1 /* K2 header */
#define KFF_K2_FRAME 2 /* K2 FRAME; frame data follows */

#endif
