/***********************************************************

File Name :
	k2time.h

Programmer:
	Phil Maechling

Description:
	This is the CIT Unix version of the kinemetric file.
	k2time.cc

Limitations or Warnings:


Creation Date:
	14 March 1995

Modification History:

**********************************************************/

#ifndef k2time_H
#define k2time_H

#include "basics.h"
#include "k2sizes.h"


// Handles date/time from 1980-2100, accurate to a second

class CK2Time 
{
   private:
      unsigned long m_nRawTime;

      int m_nYear;
      int m_nMonth;
      int m_nDayOfMonth;
      int m_nDayOfYear;
      int m_nHour;
      int m_nMin;
      int m_nSec;

   private:

      static BOOL IsLeapYear(int year);
      static unsigned long Time2Seconds(int iyear, int iday_of_year,
         int ihour, int iminute, int isec);
      static void Seconds2Time(unsigned long time, int *iyear,
         int *iday_of_year, int *ihour, int *imin, int *isec);
      static void Day2Month(int year, int day_of_year, int *month,
         int *day_of_month);
      static void Month2Day(int year, int month, int day_of_month,
         int *day_of_year);

   public:

      CK2Time(unsigned long rawTime=0);
      CK2Time(int year, int month, int dayOfMonth, int hour, int minute,
         int sec);
      int GetYear(void) { return m_nYear; }
      int GetMonth(void) { return m_nMonth; }
      int GetDayOfMonth(void) { return m_nDayOfMonth; }
      int GetDayOfYear(void) { return m_nDayOfYear; }
      int GetHour(void) { return m_nHour; }
      int GetMinute(void) { return m_nMin; }
      int GetSec(void) { return m_nSec; }
      DWORD GetRawTime(void) { return m_nRawTime; }
      BOOL operator>(const CK2Time& time)
         { return (m_nRawTime > time.m_nRawTime); }
      BOOL operator<(CK2Time& time)
         { return (m_nRawTime < time.m_nRawTime); }
      BOOL operator>=(const CK2Time& time)
         { return (m_nRawTime >= time.m_nRawTime); }
      BOOL operator<=(CK2Time& time)
         { return (m_nRawTime <= time.m_nRawTime); }
};

#endif
