/***********************************************************

File Name :
	k2sizes.h

Programmer:
	Phil Maechling

Description:
	Some of the structures had to be redefined so that they
	could be handled by the 32 bit Unix system.

Limitations or Warnings:


Creation Date:
	16 March 1995

Modification History:

**********************************************************/


#ifndef K2SIZES
#define K2SIZES 1

#define BYTE  unsigned char      /* 8 bit unsigned integer */
#define BOOL  short int          /* 16 bit unsigned integer */
#define WORD  unsigned short int /* 16 bit unsigned integer */
#define SHORT short int          /* 16 bit signed integer */
#define LONG  long               /* 32 bit signed integer */
#define DWORD unsigned long      /* 32 bit unsigned integer */
#define FLOAT float 		 /* 32 bit IEEE floating point format */


//
// Define the Layout of the FRAME HEADER structure
//

const int SAMPLES_IN_K2_BLOCK = 100;

const int BYTES_IN_FRAME_HEADER = 32;
const int MEMBERS_IN_FRAME_HEADER = 12;
 
const int START_frameType  = 0;   
const int LENGTH_frameType = 1;  

const int START_instrumentCode   = 1;   
const int LENGTH_instrumentCode  = 1; 

const int START_recorderID      = 2;   
const int LENGTH_recorderID    = 2;

const int START_frameSize      = 4; 
const int LENGTH_frameSize     = 2;

const int   START_blockTime   = 6;  
const int LENGTH_blockTime   = 4;

const int  START_channelBitMap   = 10; 
const int  LENGTH_channelBitMap   = 2;

const int  START_streamPar   = 12;  
const int  LENGTH_streamPar   = 2;

const int  START_frameStatus  = 14;  
const int  LENGTH_frameStatus  = 1; 

const int  START_pad1     = 15;  
const int  LENGTH_pad1     = 1;

const int  START_msec      = 16;  
const int  LENGTH_msec   = 2;

const int   START_pad4     = 18;  
const int  LENGTH_pad4     = 1;

const int  START_timeCode  = 19;  
const int  LENGTH_timeCode = 13;


//
// Define the layout of the K2_DIRENTRY structure
//


// K2 Direntry definition

const int BYTES_IN_K2_DIRENTRY = 22;
const int MEMBER_IN_K2_DIRENTRY = 5;

 
const int START_time = 0;   
const int LENGTH_time      = 4;  

const int START_size    = 4;  
const int LENGTH_size    = 4; 

const int START_ext    = 8;   
const int LENGTH_ext       = 4;

const int START_name = 12;   
const int LENGTH_name = 9;

const int START_attribute  = 21;  
const int LENGTH_attribute   = 1;

#endif
