/***********************************************************

File Name :
	k2rt.C

Programmer:
	Phil Maechling

Description:
	This is the main routine for a K2 packet to Q512 packet
	converter.

Creation Date:
	26 January 1996

Modification History:


Usage Notes:

	Calling convention is:
	k2rt -d -c configuration file STATION

	A default configuration file of k2net.cfg will be used
	if the -c option is not used.

**********************************************************/
#include <iostream.h>
#include <stdlib.h>

#include "basics.h"
#include "k2rt.h"
#include "utils.h"
#include "tc.h"
#include "compress.h"


int main(int argc, char *argv[])
{

  /* Variables for processing command line options */

  extern char *optarg;
  extern int  optind;
  char *cmdname;
  char *station;
  char *cfg_file = DEFAULT_CONFIG_FILE;

  /* Class declarations */

  K2toQ512 instrument;


  /* Start of Code */

  cmdname = argv[0];

  /* letter followed by a colan are expected to have paramters */

  int i;
  while((i = getopt(argc,argv,"hdCc:")) != EOF)
  {
    switch(i)
    {
      case '?' :
      case 'h' : 
        {
          print_syntax(cmdname); 
          exit(0); 
          break;
        }
//      case 'C' : 
//        {
//          c_client = TRUE; 
//          break;
//        }
      case 'd' : 
        {
          debug = TRUE; 
          break;
        }
      case 'c' : 
        {
          cfg_file = optarg; 
          break;
        }
      default: 
        {
          break;
        }
    }
  }


  /* Skip over options and get to station name */

  argv = &(argv[optind]);
  argc -= optind;


  if (argc == 1)
  {
    station = upcase(argv[0]);
  }
  else
  {
    print_syntax(cmdname);
    exit(FAILURE);
  }

  /* Initialzie the compression routine */
  
  init_compressor();

  /* The main loop is as follows */


  instrument.convert_K2_to_Q512();

  return(SUCCESS);

}
