/***********************************************************

File Name :
	jsteim.h

Programmer:
	Phil Maechling

Description:
	CIT version of steim.h

Creation Date:


Modification History:


Usage Notes:


**********************************************************/
/*
 * File:    steim.h
 *          header file for steim compression/decompression at levels 1,2,3
 */

#ifndef jsteim_H
#define jsteim_H

#include <stdio.h>
#include <string.h>

#ifndef  LONG
#define LONG        long
#endif

#ifndef SHORT
#define SHORT       short
#endif

#ifndef CHAR
#define CHAR        char
#endif

#ifndef WORD
#define WORD        unsigned short
#endif

#ifndef FLOAT
#define FLOAT       double
#endif

#ifndef BOOLEAN
#define BOOLEAN     int
#endif

#ifndef UCHAR
#define UCHAR       unsigned char
#endif 

#define REGISTER


#define  labs             abs

#ifndef  TRUE
#define  TRUE             1
#endif

#ifndef FALSE
#define  FALSE            0
#endif

  /*
   * *****************************************************************
   * the following group of definitions is needed for compression.   *
   * the conditional "STATISTICS", and code it controls may be       *
   * omitted from "production" compression code, in which histograms *
   * of what differences fit in how many bits are not needed.        *
   * *****************************************************************
   */

  /*
   * to simplify buffer wrap handling, 
   * PEEKELEMS should be set to at least the largest
   * number of samples (N) to be written to the buffer + 143, 
   * the maximum number of samples
   * in a level 3 frame. this is really only a convenience 
   * for the peek buffer management
   * routines in this module. as long as the user does not 
   * overflow the peek buffer, and keeps
   * it sufficiently full that no samples are "padded" by 
   * compress_frame, the peek buffer
   * can be filled any way you like.
   */


#define    PEEKELEMS           150
#define    WORDS_PER_FRAME     16
#define    MAXSAMPPERWORD      9
#define    ICONSTCODE          0xE0000000
#define    ICONSTMASK          (~ICONSTCODE)
#define    ICONSTSIGN          (((LONG)ICONSTMASK+1) >> 1)
#define    NOTDIFFERENCE       0xC8000000
#define    SECONDDIFF          0x80000000
#define    REPLACEMENTMASK     0x70000000


  typedef union {
      CHAR                  b[4] ;
      SHORT                 s[2] ;
      LONG                  l ;
    } COMPWORD ;


  typedef LONG              peekbuffertype[PEEKELEMS];

  typedef COMPWORD          compressed_frame[WORDS_PER_FRAME];

  typedef compressed_frame  *cfp;



    typedef struct {
        SHORT                 next_in ;
        SHORT                 peek_total, next_out ;
        LONG                  frames ;
        LONG                  last_1, last_2, final ;
        peekbuffertype        *peeks ;
        compressed_frame      framebuf ;
        SHORT                 peek_threshold ;
      } compression_continuity ;


    typedef compression_continuity *ccptype ;


    typedef struct {
        ccptype               ccp ;
        SHORT                 bestdiff ;
        SHORT                 difference ;
        SHORT                 trials ;
        SHORT                 firstframe ;
        SHORT                 framespertrial ;
        SHORT                 framesperpackage ;
        SHORT                 level ;
        SHORT                 flip ;
      } adaptivity_control ;

    typedef adaptivity_control *adptype ;

  /*
   * the following structures allow build complete "records", 
   * which comprise a GENERICHDRL-byte
   * header, followed by up to (MAXTOTALFRAMESPERRECORD-1) 64-byte 
   * compressed "frames".
   * a pointer to such a "generic_data_record" may be cast to point 
   * to SEED data records,
   * or NSN data records, or whatever, while allowing all the 
   * compression library functions
   * not to care what kind of header will be installed. 
   * you should set GENERICHDRL
   * to the size of headers on the types of actual data records 
   * you're using, bearing in mind that
   * "frames" must begin at least on a "long" boundary.
   */

#define MAXTOTALFRAMESPERRECORD          7 
#ifndef GENERICHDRL
#define GENERICHDRL                     64
#endif

  typedef struct {
      CHAR                              head[GENERICHDRL] ;
      compressed_frame                  frames[MAXTOTALFRAMESPERRECORD-1] ;
    } generic_data_record ;


  typedef struct {
      adptype                           adp ;
      generic_data_record               *gdr ;
      LONG                              nsamples ;
    } generic_data_record_control ;

  typedef generic_data_record_control   *gdptype ;

#endif
