/***********************************************************

File Name :
	ikpp.h

Programmer:
	Phil Maechling

Description:
	Incoming K2 Packet Processor (ikpp)

	This is a class definition for a class that can input
	a received K2 packet, and process it.

Creation Date:
	27 January 1995

Modification History:


Usage Notes:


**********************************************************/
#ifndef ikpp_H
#define ikpp_H

#include "commctrl.h"
#include "sockctrl.h"
#include "packet.h"
#include "qpacket.h"
#include "config.h"
#include "jsteim.h"
#include "k2time.h"

const SAMPLES_IN_K2_PACKET = 100;

struct PACKET_DATA 
{
   BYTE Data[PACKET_MAX_DATALENGTH];
   WORD DataCksum;
};

struct k2_packet_header_type
{
  int packet_type;
  unsigned int link_level_seq_no;
  int source_id;
  int destination_id;
  int data_length;
};

struct k2_data_block_header_type
{
  int instrument_serial_number;
  int stream_number;
  int gps_fault;
  int hardware_fault;
  int memory_fault;
  int battery_low;
  int compression_mode;
  unsigned int stream_sequence_number;
  unsigned int seconds;
  unsigned int milliseconds;
};


class Incoming_K2_Packet_Processor
{

  public:

    Incoming_K2_Packet_Processor();

    ~Incoming_K2_Packet_Processor();

    void process_k2_packet(CCommControl& k2_port,
			   CPacket& valid_packet,
			   SocketControl& dl_socket,
			   QPacket& outpacket);

  private:


    int convert_data_packet(CPacket& rxpacket,
		            SocketControl& dl_socket,
		            QPacket& dl_packet);

    int DecodeSamples(int dblock[],PACKET_DATA* packet_data);

    int DecodePacketHeader(CPacket& rxpacket,
			   struct k2_packet_header_type& pack_header);

    int DecodeDataBlockHeader(CPacket& rxpacket,
			      struct k2_data_block_header_type& data_header);

    void invert_data(int dblock[],
		     int num_samples);


    process_data_packet();
    process_message_packet();
    selected_channels_type chans;
    channel_inversion_type invert;
    
    int datablock[SAMPLES_IN_K2_PACKET];
  
    struct k2_packet_header_type     packet_header;
    struct k2_data_block_header_type data_header;

    char station_name[5];

};

#endif
