/***********************************************************

File Name :
	compress.C

Programmer:
	Phil Maechling

Description:
	This initializes static global compression variables.

Creation Date:
	27 January 1995

Modification History:


Usage Notes:


**********************************************************/
#include <iostream.h>
#include "compress.h"
#include "jsteim.h"
#include "config.h"
#include "steimlib.h"

int init_compressor(void)
{

  selected_channels_type chans;

  // Initialize global variables

  reserved_dataframes = 0;
  dataframes = 7;
  level = 1;
  adapt = 1;
  flip = 0;
  int difftyp = 1;


  // get_streams_config(struct selected_channel_type chans);

  chans.c_0 = TRUE;
  chans.c_1 = TRUE;
  chans.c_2 = TRUE;
  chans.c_3 = FALSE;
  chans.c_4 = FALSE;
  chans.c_5 = FALSE;

  int channel = 1; // This is used only to printout channel number on error.

  if (chans.c_0 == TRUE)
  {
    gdp_0 = 
      init_generic_compression(difftyp,adapt,dataframes,level,flip,&pack_0);

    clear_compression(gdp_0->adp->ccp,level);
    if (gdp_0 == NULL)
    {
      cout << "Initialization failed for channel :" << channel << endl;
      return (FAILURE);
    }
  }


  channel = ++channel;
  if (chans.c_1 == TRUE)
  {
    gdp_1 = 
      init_generic_compression(difftyp,adapt,dataframes,level,flip,&pack_1);

    clear_compression(gdp_1->adp->ccp,level);
    if (gdp_1 == NULL)
    {
      cout << "Initialization failed for channel :" << channel << endl;
      return (FAILURE);
    }
  }

  channel = ++channel;
  if (chans.c_2 == TRUE)
  {
    gdp_2 = 
      init_generic_compression(difftyp,adapt,dataframes,level,flip,&pack_2);

    clear_compression(gdp_2->adp->ccp,level);
    if (gdp_2 == NULL)
    {
      cout << "Initialization failed for channel :" << channel << endl;
      return (FAILURE);
    }
  }

  channel = ++channel;
  if (chans.c_3 == TRUE)
  {
    gdp_3 = 
      init_generic_compression(difftyp,adapt,dataframes,level,flip,&pack_3);

    clear_compression(gdp_3->adp->ccp,level);
    if (gdp_3 == NULL)
    {
      cout << "Initialization failed for channel :" << channel << endl;
      return (FAILURE);
    }
  }

  channel = ++channel;
  if (chans.c_4 == TRUE)
  {
    gdp_4 = 
      init_generic_compression(difftyp,adapt,dataframes,level,flip,&pack_4);

    clear_compression(gdp_4->adp->ccp,level);
    if (gdp_4 == NULL)
    {
      cout << "Initialization failed for channel :" << channel << endl;
      return (FAILURE);
    }
  }

  channel = ++channel;
  if (chans.c_5 == TRUE)
  {
    gdp_5 = 
      init_generic_compression(difftyp,adapt,dataframes,level,flip,&pack_5);

    clear_compression(gdp_5->adp->ccp,level);
    if (gdp_1 == NULL)
    {
      cout << "Initialization failed for channel :" << channel << endl;
      return (FAILURE);
    }
  }

  return(SUCCESS);
}


//***********************************************************
// This initilizes the J. Steim compression algorithms.
//***********************************************************

int init_steim_compressor(generic_data_record_control* this_gdp,
    		    generic_data_record* pack,
    		    int channel)
{
  int difftyp = 1;
  this_gdp = init_generic_compression(difftyp,adapt,dataframes,level,flip,pack);
  clear_compression(this_gdp->adp->ccp,level);
 
  if (this_gdp == NULL)
  {
    cout << "Initialization failed for channel :" << channel << endl;
    return (FAILURE);
  }
  else
  {
    return(SUCCESS);
  }
}
