/***********************************************************

File Name :
	commctrl.h

Programmer:
	Phil Maechling

Description:
	This is the class declaration for the commmctrl class.
	It is a port to unix of kinemetrics PC software which
	does communications routines on their qtwin software.

Limitations or Warnings:


Creation Date:
	28 March 1995

Modification History:

**********************************************************/

#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/uio.h>
#include <unistd.h>
#include "basics.h"
#include "packet.h"

// commctrl.h : header file
/************************************************************/
#ifndef commcontrol_H
#define commcontrol_H

class CCommControl 
{
      
   public:

     // Construction

      CCommControl(); // standard constructor  
      ~CCommControl();

    // Control Serial port

      int OpenPort(char* portname,int baudrate);
      int ClosePort();

    // Send Packets

       void Send(CPacket& packet);
       void Send(CPacket *pPkt);

    // Read Packets

       BOOL ReadComm();
       CPacket& LastPacket();

    // Count Retries

       void AckFailed();
       void ZeroAckCounter();
       int  NumberOfAckFailures();
      

   private:

      int baud_rate;
      char port_name[100];
      BOOL port_open;
      BOOL m_escFlag;         // TRUE if last char was a SLIP_ESC
      CByteArray rawarray;    // Storage for initial, unprocessed data
      CByteArray m_buf;       // Destination of processed chars, while
		              //   constructing a packet from the input chars
                              //   Considered a simple array, not a packet
      CPacket rxdPacket;      //  Location of received packet
      struct termios trm;
      int k2port;
      int res;
      int ack_failures;

};

#endif
