/***********************************************************

File Name :
	commctrl.C

Programmer:
	Phil Maechling

Description:
	This is the kinemetrics program commctrl.cc ported
	over to unix. This is the class which performs most
	or all of their communications routines.

Limitations or Warnings:


Creation Date:
	28 March 1995

Modification History:

**********************************************************/
#include <iostream.h>
#include <string.h>
#include <assert.h>
#include "basics.h"
#include "commctrl.h"
#include "status.h"
#include "verbose.h"



// commctrl.cpp : implementation file
//


#define RECEIVE_BUFSIZE 8*1024
#define TRANSMIT_BUFSIZE 8*1024

Verbosity cget;

//-------------------------------------------------//

CCommControl::CCommControl()
{
  strcpy(port_name,"");
  baud_rate = 19200;
  port_open = FALSE;
  m_escFlag = FALSE;
  k2port = 0;
  ack_failures = 0;
}

CCommControl::~CCommControl()
{

}

int CCommControl::OpenPort(char* portname,int baudrate)
{

  k2port = open(portname, O_RDWR);

  if (k2port < 0) 
  {
    cout << "Cannot open "<< portname << endl;
    return(FAILURE);
  }

  res = tcgetattr(k2port,&trm);
  if (res < 0)
  {
    cout << "error getting port settings" << endl;
    return(FAILURE);
  } 

 
  // Put the port into "raw" mode
     
  trm.c_iflag &= ~(INLCR | ICRNL | IUCLC | ISTRIP | IXON | BRKINT);
  trm.c_iflag &= IGNBRK | IGNPAR | INPCK;  // drop chars with 
					   // parity errs

  trm.c_oflag = 0; 			  // no post processing
					  // such as cr

  trm.c_lflag &= ~(ICANON | ISIG | ECHO);
  trm.c_lflag &= NOFLSH;

  // Set Min = 0 and time = 50 * .1 (5 seconds).
  // Read on port should then return after 5 seconds even if no chars
  // are read

  trm.c_cc[VMIN] = 0;
  trm.c_cc[VTIME] = 50; 

  if (baudrate == 38400) 
  {
    trm.c_cflag = (CS8 | CREAD | CLOCAL | B38400);
  } 
  else if (baudrate == 19200) 
  {
    trm.c_cflag = (CS8 | CREAD | CLOCAL | B19200);
  } 
  else if (baudrate == 9600)
  {
    trm.c_cflag = (CS8 | CREAD | CLOCAL | B9600);
  }
  else if (baudrate == 1200)
  {
    trm.c_cflag = (CS8 | CREAD | CLOCAL | B1200);
  }
  else
  {
    cout << "Unsupported Baud Rate : " << baudrate << endl;
    return(FAILURE);
  }


  res = tcsetattr(k2port,TCSANOW,&trm);
  if (res < 0)
  {
    cout << "Error setting baud rate on serial port line " << portname << endl;
    return(FAILURE);
  }
  else
  {
    if (cget.verbose_mode())
    { 
      cout << "serial port " << portname << " Open at baud : " << baud_rate  
      << endl;
    }
  }

  port_open = TRUE;
  return(SUCCESS);
}


int CCommControl::ClosePort()
{
  if ((port_open == TRUE) && (k2port > 0))
  {
    if (cget.verbose_mode())
    {
      cout << "Closing Comm Port " << port_name << endl;
    }
    close(k2port);
    k2port = 0;
  }
  return(0);
}


void CCommControl::Send(CPacket& packet)
{
  Send(&packet);
}

void CCommControl::Send(CPacket *pPkt)
{
   // send a packet to K2
   // Calculate checksum
   pPkt->SetHeaderChecksum();
   pPkt->SetDataChecksum();

   // Create temporary data buffer
   CByteArray data;
   WORD packetSize = pPkt->GetPacketSize();
   if (packetSize > PACKET_MAX_SIZE)
   {
      cout << "Packet is too big "<< endl;
      return; // packet too big!
   }

   if (cget.verbose_mode())
   {
     cout << " This shows packet with checksum in it " << endl;
     pPkt->Dump();
   }

   // allow room for SLIP codes and 3 checksum bytes

   data.SetSize(2*(packetSize)+2); 

   BYTE c;
   data[0] = PKTFRAME; // first char
   int i,j;
 
  for (i=0, j=1; i <  (int) packetSize; i++)
   { // Translate packet 
      c = pPkt->GetAt(i);
      if (c == PKTFRAME)
      {
         data[j++] = PKTESC;
         data[j++] = END_EQUIVALENT;
      }
      else if (c==PKTESC)
      {
         data[j++] = PKTESC;
         data[j++] = ESC_EQUIVALENT;
      }
      else
         data[j++] = c;
   }

   data[j++] = PKTFRAME; // last char

   int writeres;
   writeres = write(k2port,&data[0], j);

   if (writeres != j)
   {
     cout << "Error on Write to port : " << port_name << endl;
     sleep(30);
     return;
   }
}

//--------------------------------------------------------------//

BOOL CCommControl::ReadComm()
{
  int inputSize;
  char buf[PACKET_MAX_SIZE];
  BOOL looking_for_packet;
  int mbufbound;
  int rawbound;
  int place;

  if(port_open != TRUE)
  {
    cout << "Error in ReadComm. Port not open "<< endl;
    return (FALSE);
  }

  looking_for_packet = TRUE;

  while (looking_for_packet)
  {

    if (cget.verbose_mode())
    {
      cout << "top of while loop : RawArrray : " << rawarray.GetSize() <<endl;
    }

    if (rawarray.GetSize() < (PACKET_HDR_SIZE + 2) )
    {
      if (cget.verbose_mode())
      {
        cout << "Reading serial port " << endl;
      }

      inputSize = read(k2port,buf,PACKET_MAX_SIZE);

      if (cget.verbose_mode())
      {
        cout << "Number of bytes read : " << inputSize << endl; 
      }

      if (inputSize < 0)
      {
        cout << "Error reading serial port " << endl;
        return(FALSE);
      }
      else if (inputSize == 0) 
      {
        if (cget.verbose_mode())
        { 
          cout << "Serial Port timed out" << endl;
        }
        return(FALSE);
      }

      if ((rawarray.GetSize() + inputSize) > (PACKET_MAX_SIZE))
      {
        cout << "Input rawarray has grown too large" << endl;
        return(FALSE);
      }
      else
      {
        place = rawarray.GetUpperBound();
        for(int iloop=0;iloop<inputSize;iloop++)
        {
          ++place;
          rawarray.SetAtGrow(place,(BYTE) buf[iloop]); 
        }
      }
    } // End if we need more chars to start processing a packet

    if (cget.verbose_mode())
    {
      cout << "Past read port tests : RawArrray : " 
        << rawarray.GetSize() <<endl;
    }

    // We have enough char to try to find a packet

    rawbound  = rawarray.GetUpperBound();
    unsigned char c;
    for (int qloop=0; qloop<=rawbound; qloop++)
    { 

      c = rawarray[0];      // transfer current character to c
      rawarray.RemoveAt(0); // remove it from raw array

      /*

         if (escaping a character)
         else if (current char is an escape)
         else if (current char is a pckframe)
         else (normal character )

      */


      if (m_escFlag)  // this means "Was last char an escape ?"
      {
        m_escFlag = FALSE;   
        if (c == ESC_EQUIVALENT)
        {
          mbufbound = m_buf.GetUpperBound();
          ++mbufbound;
          m_buf.SetAtGrow(mbufbound,PKTESC);
        }
        else if (c == END_EQUIVALENT)
        {
          mbufbound = m_buf.GetUpperBound();
          ++mbufbound;
          m_buf.SetAtGrow(mbufbound,PKTFRAME);
        }
        else
        { 
          if(cget.verbose_mode())
          {
            cout << "Found unknown char following an escape " << endl;
            cout << "Dropping current packet. Restarting packet formation" 
            << endl;
          }

          m_buf.RemoveAll();
        }
        continue;
      }
      else if (c == PKTESC)
      {
        if (cget.verbose_mode())
        {
          cout << "Found escape flag." << endl;
        }

        m_escFlag = TRUE;
        continue;
      }
      else if (c == PKTFRAME)
      {
        mbufbound = m_buf.GetUpperBound();
        ++mbufbound;
        if (mbufbound <= 0)
        {
          if (cget.verbose_mode())
          {
            cout << "Start of Packet Found." << endl; 
          }
          continue;
        }
        else
        { 
          if (cget.verbose_mode())
          {
            cout << "Packet frame found. Packet Complete " << endl;
            cout << "Received Packet Size :    " << m_buf.GetSize() << endl;
            cout << "Copy Byte array to packet " << endl;
          }

          rxdPacket.RemoveAll();
          rxdPacket.InsertAt(0,&m_buf);
          m_buf.RemoveAll();

          if (!rxdPacket.Verify())
          { 
            if (cget.verbose_mode())
            {
              cout << "Packet verification error " << endl;
              cout << "Removing all data from mbuf" << endl; 
            }
            cout << "Verification Error in ReadComm" << endl;
            continue;
          }
          else
          {
            if (cget.verbose_mode())
            {
              cout << "We have a good packet in rxdPacket " << endl;
              cout << "rxdPacket Size : " << rxdPacket.GetSize() << endl;
              rxdPacket.Dump(); 

              cout << "Received Sequence Number : " 
                << ((int) rxdPacket.GetSeqNo()) << endl;
   
              cout << "Received Source Number : " 
                << ((int) rxdPacket.GetSource()) << endl;

              cout << "Received Destination Number : " 
                << ((int) rxdPacket.GetDestination()) << endl;
           
              }
	    return(TRUE);

          } // End of if verify
        } // End of if character is frame character
      }
      else // else to if (m_escflag)
      {
        mbufbound = m_buf.GetUpperBound();
        ++mbufbound;
        m_buf.SetAtGrow(mbufbound, (BYTE) c);
      }
    } // end for
  } //end while
} //end ReadComm


CPacket& CCommControl::LastPacket()
{
  return(rxdPacket);
}


void CCommControl::ZeroAckCounter()
{
  ack_failures = 0;
}

void CCommControl::AckFailed()
{
  if (ack_failures < 10000) // Don't overflow ever
  {
    ++ack_failures;
  }
}

int CCommControl::NumberOfAckFailures()
{

  return(ack_failures);

}
