/***********************************************************

File Name :
	cba.h

Programmer:
	Phil Maechling

Description:
	This is the class definition for the class byte array
	written for the Unix machine. Microsoft delivers this
	with their compiler. It was written here so the kinemetrics
	windows code could be reused.

Limitations or Warnings:


Creation Date:
	28 March 1995

Modification History:

**********************************************************/
#ifndef cba_H
#define cba_H

#include "basics.h"
#include "k2sizes.h"

#define SIZE_T_MAX 3010 // This size is based on maximun packet size plus
                        // at least 11 which is minimum packet size
			// This max size can be read and stored in a 
			// raw arrary before processing.

class CByteArray
{

public:

// Construction
	CByteArray();
	~CByteArray();

// Attributes
	int GetSize() const;
	int GetUpperBound() const;
	void SetSize(int nNewSize, int nGrowBy = -1);

// Operations
	// Clean up
	void FreeExtra();
	void RemoveAll();

	// Accessing elements
	BYTE GetAt(int nIndex) const;
	void SetAt(int nIndex, BYTE newElement);
	BYTE& ElementAt(int nIndex);

	// Potentially growing the array
	void SetAtGrow(int nIndex, BYTE newElement);
	int Add(BYTE newElement);

	// overloaded operator helpers
	BYTE operator[](int nIndex) const;
	BYTE& operator[](int nIndex);

	// Operations that move elements around
	void InsertAt(int nIndex, BYTE newElement, int nCount = 1);
	void RemoveAt(int nIndex, int nCount = 1);
	void InsertAt(int nStartIndex, CByteArray* pNewArray);

//Debug

  void Dump() const;

// Implementation
protected:
	BYTE* m_pData;   // the actual array of data
	int m_nSize;     // # of elements (upperBound - 1)
	int m_nMaxSize;  // max allocated
	int m_nGrowBy;   // grow amount


};

#endif
