       subroutine tersp(fi,df,nf,stnm,chanl,cresp,iy,im,id)
c      compute response for TERRAscope type stations
c      revised from irisr.f, 6/1/1991, Hiroo Kanamori
c      response near and above the Nyquist freq. fh is approximate
c      cresp(*) is the complex response function
c      identify station and channel by, for example, pas  and vbbz
c      fi=initial frequency, df=frequency increment, nf=# of 
c      frequencies, stnm=station name, chanl=channel id
c      prepare a table tersta.dat that list the constants.
c      iy, im, id indicate the date, if iy=0 (im, id dummy), then
c      a generic response is used.
       character stnm*10, chanl*5, stnml*10, chanll*5
       complex  cresp(*)
       parameter (pi=3.14159265,efh=0.26,rb=1.e-10)
       iday=juldat(iy,im,id)
       open(27,file='tersta.dat')
310    continue
       read(27,'(a10,a5,4e10.2,i4,i2,i2,1x,i4,i2,i2)',
     2 end=320)  stnml, chanll,f0,h,s,fh,iy1,im1,id1,iy2,im2,id2
       if (iy.eq.0)  then
       if(stnml.eq.stnm.and.chanll.eq.chanl)  then
       go to 300
       endif
       go to 310
       endif
       iday1=juldat(iy1,im1,id1)
       iday2=juldat(iy2,im2,id2)
       if(stnml.eq.stnm.and.chanll.eq.chanl.and.
     2 ndays(iy1,iday1,iy,iday).ge.0.and.ndays(iy,iday,iy2,iday2).ge.0)
     2 then
       go  to 300
       endif
       go to 310
320    write(*,*) 'The following station is not on tersta.dat'
       write(*,'(a10,a5,i4,2i2)') stnm,chanl,iy,im,id
       stop
300    continue
       if(chanl(1:2).eq.'lg') then
       sa=s*(2.*pi*f0)**2
       do  51  i=1, nf
       f=fi+df*float(i-1)
       cresp(i)=cmplx(f**2)/cmplx(f**2-f0**2,-2.*h*f0*f)
       cresp(i)=cresp(i)*cmplx(sa,0.)
51     continue
       else
       do  50  i=1, nf
       f=fi+df*float(i-1)
       if(f.ge.fh) then
       cresp(i)=cmplx(rb,0.0)
       elseif(f.le.(1.-efh)*fh) then
       cresp(i)=cmplx(0.,2.*pi*f**3)/cmplx(f**2-f0**2,-2.*h*f0*f)
       cresp(i)=cresp(i)*cmplx(s,0.)
       else
       c1=0.5*(1.+cos(pi*(f-(1-efh)*fh)/(efh*fh)))+rb
       cresp(i)=cmplx(0.,2.*pi*f**3)/cmplx(f**2-f0**2,-2.*h*f0*f)
       cresp(i)=cresp(i)*cmplx(s*c1,0.0)
       endif
50     continue
       endif
       close(27)
       return
       end
      function  juldat(iy,m,id)
c     compute julian date,  6/26/1991  h. kanamori
      dimension  idm(12)
      data (idm(i),i=1,12)/31,28,31,30,31,30,31,31,30,31,30,31/
      il=1-mod(iy,4)
      if(mod(iy,100).eq.0.and.mod(iy,400).ne.0)  il=0
      juldat=0
      do 50 i=1, m-1
      juldat=juldat+idm(i)
      if(i.eq.2.and.il.eq.1) juldat=juldat+1
50    continue
      juldat=juldat+id
      return
      end
      FUNCTION NDAYS(IY1,ID1,IY2,ID2)
C  FINDS THE NUMBER OF DAYS BETWEEN TWO DATES, GIVEN AS YEAR AND DAY; THE
C  SECOND DATE (GIVEN BY IY2 AND ID2) IS TAKEN TO BE LATER. THE NUMBER OF
C  DAYS IS 0 IF THE DATES ARE THE SAME, 1 IF DATE 2 IS ONE DAY LATER, -1
C  IF IT IS ONE DAY EARLIER, AND SO ON.
C   **FOR 16-BIT INTEGERS, THE MAXIMUM SPAN IS 89 YR 257 DAYS.
C
C  $$$$CALLS ONLY SYSTEM ROUTINES
C
C     AUTHOR - DUNCAN CARR AGNEW
C
      LEAP(JJ) = 1 - (MOD(JJ,4)+3)/4
      NDAYS = ID2 - ID1
      IF(IY1.EQ.IY2) RETURN
C  IN SEPARATE YEARS - COUNT UP INTERVENING DAYS
      IF(IY1.GT.IY2) GO TO 5
      NDAYS = 365 + LEAP(IY1) - ID1
      NDAYS = NDAYS + ID2
C  IF YEARS ADJACENT WE ARE DONE
      IF(IY2.EQ.IY1+1) RETURN
      I1 = IY1+1
      I2 = IY2-1
      DO 3 I=I1,I2
      NDAYS = NDAYS + 365 + LEAP(I)
C  CLAVIAN (GREGORIAN) INTERCALATION
 3    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
      RETURN
C  THIS PART IS USED WHEN THE SECOND YEAR IS EARLIER THAN THE FIRST
 5    NDAYS = 365 + LEAP(IY2) - ID2
      NDAYS = NDAYS + ID1
      IF(IY1.EQ.IY2+1) GO TO 9
      I2 = IY2+1
      I1 = IY1-1
      DO 7 I=I2,I1
      NDAYS = NDAYS + 365 + LEAP(I)
 7    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
 9    NDAYS = -NDAYS
      RETURN
      END
