	subroutine sac2hk(sacfile,hkfil,nterr)
c
c     converts SAC binary files to HK's format
c
c     modified from sactokik.f originally written by HKT, 08/17/90
c     H. kanamori  (Feb. 1993)
c     nhr = start time hour UTC
c     nmin = start time min UTC
c     nsec = nnp
c     nnp   = number of points
c
c
      parameter (maxp=40000)
      real x(maxp) 
      integer yr,hr,min,sec,msec,nhr,nmin,nsec,nterr
      character sacfile*80, sta*4, comp*1
      character hkfil*80
      call rsac1(sacfile,x,np,b,dt,maxp,nerr)
      call getnhv('NZYEAR',yr,nerr)
      call getnhv('NZJDAY',dy,nerr)
      call getnhv('NZHOUR',hr,nerr)
      call getnhv('NZMIN',min,nerr)
      call getnhv('NZSEC',sec,nerr)
      call getnhv('NZMSEC',msec,nerr)
      call getkhv('KSTNM',sta,nerr)
      call getkhv('KCMPNM',comp,nerr)
      open(16,file=hkfil)
c     nhr, nmin, nsec  give the new start time.
      nhr = hr
      nmin = min
      nsec = sec
c     number of points desired:  np

      write(16,103) sta,comp,nhr,nmin,nsec, b
      write(16,'(6(i4,1x))') yr,dy,hr,min,sec,msec
      write(16,'(i10,g12.5)') np,dt
103   format(a4,".",a1,"    ref time: ",i2,":",i2,":",i2,",    delay
     /time: ",e12.5)
      write(16,'(6e12.6)') (x(i),i=1, np)
      close(16)
      nterr = 0

300   continue
      end
