      FUNCTION NDAYS(IY1,ID1,IY2,ID2)
C  FINDS THE NUMBER OF DAYS BETWEEN TWO DATES, GIVEN AS YEAR AND DAY; THE
C  SECOND DATE (GIVEN BY IY2 AND ID2) IS TAKEN TO BE LATER. THE NUMBER OF
C  DAYS IS 0 IF THE DATES ARE THE SAME, 1 IF DATE 2 IS ONE DAY LATER, -1
C  IF IT IS ONE DAY EARLIER, AND SO ON.
C   **FOR 16-BIT INTEGERS, THE MAXIMUM SPAN IS 89 YR 257 DAYS.
C
C  $$$$CALLS ONLY SYSTEM ROUTINES
C
C     AUTHOR - DUNCAN CARR AGNEW
C
      LEAP(JJ) = 1 - (MOD(JJ,4)+3)/4
      NDAYS = ID2 - ID1
      IF(IY1.EQ.IY2) RETURN
C  IN SEPARATE YEARS - COUNT UP INTERVENING DAYS
      IF(IY1.GT.IY2) GO TO 5
      NDAYS = 365 + LEAP(IY1) - ID1
      NDAYS = NDAYS + ID2
C  IF YEARS ADJACENT WE ARE DONE
      IF(IY2.EQ.IY1+1) RETURN
      I1 = IY1+1
      I2 = IY2-1
      DO 3 I=I1,I2
      NDAYS = NDAYS + 365 + LEAP(I)
C  CLAVIAN (GREGORIAN) INTERCALATION
 3    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
      RETURN
C  THIS PART IS USED WHEN THE SECOND YEAR IS EARLIER THAN THE FIRST
 5    NDAYS = 365 + LEAP(IY2) - ID2
      NDAYS = NDAYS + ID1
      IF(IY1.EQ.IY2+1) GO TO 9
      I2 = IY2+1
      I1 = IY1-1
      DO 7 I=I2,I1
      NDAYS = NDAYS + 365 + LEAP(I)
 7    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
 9    NDAYS = -NDAYS
      RETURN
      END
