        program  engymagr
c       version 1.0, sed 1/31/1993  h. kanamori
c       program to integrate square of a time series, and compute
c       energy magnitude
c       W-A response is also computed
c       h. kanamori,  3/1/1991 
	character*80  infil, outfil, id1,id2, ievent, ista	
	character*5  istalst
	character ifmt*1, itype*1, ifilt*1
	character*5  stn(100)
        character itype1*80, infil1*80 
        character stnn*80, filn*80
        character icomp*1
        integer s, sum, avd
	parameter  (ndim=16500,tp=0.8, e=-0.8,amag=2800.,avd=1)
	dimension  sx(ndim), xx(ndim),idd(8),xf(ndim)
	dimension  alatl(100), alongl(100), hlist(100)
        dimension stnn(100), filn(200,3)
	common /ts/ x(ndim), t(ndim), intg
        open(26,file='o_engymag3')
	open(24,file='o_engymag2')
	open(22,file='o_engymag')
	open(25,file='stacor.dat')
        open(17,file='stalist')
	open(29,file='i_engymagr')
        read(17,*) nstl
        read(17,'(a5,5x,3f10.3)') (stn(i),alatl(i),alongl(i), 
     2  hlist(i),i=1, nstl)
        close(17)
        open(17,file='fintfpara')
c       read finite fault parameter, fstrike=strike of fault (clockwise from N)
c       b1=length in strike direction,  b2=length in -strike direction
c       for most cases (point source), b1=0. and b2=0.
        read(17,*)  fstrike, b1, b2
        close (17)
        if((b1.gt.0.).or.(b2.gt.0.)) then
        write(22,*)  'finite fault is used'
        write(22,'(3f10.2)')  fstrike, b1, b2
        write(*,*)  'finite fault is used'
        write(*,'(3f10.2)')  fstrike, b1, b2
        endif
c       end read fault parameters
330     continue
	read(25,'(a5,4f10.3)',end=38)  istalst, stg1,stg2,v2c,amlcor
	write(22,'(a5,4f10.3)')  istalst, stg1,stg2,v2c,amlcor
	go to 330
38      continue
        close(25)
c	write(*,*)  'input density, and velocity'
	read(29,*)  rho,  velocity
	write(22,'(2f10.3)')  rho, velocity
c	write(*,*) ' input gain factors  '
	read(29,*)  amults, amultv
c       these are now dummy variables
	write(22,'(2e12.5)') amults, amultv
c	write(*,*)  'input energy attenuation parameters, 
c     2  and reference depth'
	read(29,*) cqr0,anqr0,akqr0,rref
	write(22,'(4g12.5)') cqr0,anqr0,akqr0,rref
c	write(*,*) 'read 2 sets of coefficients for logE vs M'
	read(29,*) cen1a,cen1b,cen2a,cen2b
	write(22,'(4f10.3)') cen1a,cen1b,cen2a,cen2b
c        write(*,*) 'choose format, (v)ariable length or (s)tandard'
	read(29,'(a1)')  ifmt
c	write(*,*) 'high-pass filter at 0.2Hz?, then (f), if not (n)'
c	read(29,'(a1)')  ifilt
310     continue
c        write(*,*)  'read event name'
	read(29,1)  ievent
        write(*,1)  ievent
	if(ievent.eq.' ') go to 375
	write(24,1) ' '
	read(29,*)  alate, alonge,  depth
	write(24,1)  ievent
	write(24,'(3f10.3)')  alate, alonge, depth
        read(29,*) iyre, ide, ihe, ime, isece, imse
        write(26,1) ievent
        write(26,'(2f12.3, f10.1)') alate, alonge, depth
        write(26,'(6i5)') iyre, ide, ihe, ime, isece, imse
        read(29,'(a80)') infil1
c        read(29,'(a80)') itype1
        call rdf3(infil1,filn,stnn, ns)
c        itype(1:1)=itype1(1:1)
        do istn=1, ns
        write(*,'(i5)')  istn
        ista=stnn(istn) 
        write(*,'(a5)') ista
c       if itype="b", vbb,  "s",  strong motion
	open(25,file='stacor.dat')
30      continue
	read(25,'(a5,4f10.3)',end=32)  istalst, stg1,stg2,v2c,amlcor
	if(ista(1:5).eq.istalst) go to 31
	go to 30
32      write(*,*) 'station name is not in stacor.dat'
	pause
31      continue
c       stg1 and stg2 are now dummy variables
	close(25)
        write(22,1) ievent
	write(22,'(a5)') ista
        do  68 i=1, nstl
        if(ista(1:5).eq.stn(i)) then
        alatst=alatl(i)
        alongst=alongl(i)
        go to  311
        endif
68      continue
        write(*,*) 'station is not on the list stalist'
        stop
311     continue
        call  great(alate, alonge,alatst,alongst,dist,distd,gc,az,baz)
	write(24,'(a5,4f12.2)') ista,alatst, alongst, dist, depth
	depthr=depth
        diste=dist
	if (depth.le.rref) depthr=rref
c       compute effective distance for finite fault
        angle1=(fstrike+(180.-az))
        if(cos(angle1*0.01745).gt.0.) then
          al1=b2
          al2=b1
           else
            al1=b1
            al2=b2
        endif
        distef=efectr(dist, angle1, al1, al2)
        write(22, '(4f10.2)')  diste, az, baz, distef
c       replace dist with distef
        dist=distef
	range=sqrt(dist**2+depthr**2)
	write(22,'(2g12.3,1x,g12.3,1x,g12.3)')  dist,az, depth,  range
	amp0=qr1(rref,cqr0,anqr0,akqr0)
	amp=qr1(range,cqr0,anqr0,akqr0)
	ensum=0.0
	amlav=0.0
	ntrace=0
	amult=rho*velocity*4.*3.141592*rref**2*amp0**2/(4.*amp**2)
	amult=amult*1.e15
372     continue
        do  istc=1,3
c	write(*,*) 'input file name'
        infil=filn(istn,istc)
        call stripbc(infil,80,nnbc)
        icomp=infil(nnbc:nnbc)
        itype=infil(nnbc-1:nnbc-1)
        write(*,'(a40,a1,1x,a1)')  infil, itype, icomp
1	format(a80)
        ntrace=ntrace+1
	open(15,file=infil)
	read(15,1,err=500) id1
	read(15,*) iyrs, ids, ihs, ims, isecs, imss
	read(15,*) n, dt
        if(n.gt.ndim) then
	write(*,*) 'data too large, increase ndim'
	pause
	endif
        idsjul=ids+julday(1,1,iyrs)-1
        call caldat(idsjul,month,iday,iyyy)
        write(*,*)  iyyy, month, iday
        amultv=1./tergain(ista(1:10),'vbb'//icomp//' ',iyyy,month,iday)
        amults=1./tergain(ista(1:10),'lg'//icomp//'  ',iyyy,month,iday)
        ndayd=ndays(iyre,ide,iyrs,ids)
        idif=ndayd*24*3600+(ihs-ihe)*3600+(ims-ime)*60+(isecs-isece) 
        sdif=float(idif)+(imss-imse)*0.001
        ptimes=ptime(diste,depthr,6.3)
        sptimes=ptimes*0.731
        write(22,'(3f10.1)')  sdif, ptimes,  sptimes
        if(ifmt.eq.'v') then
	l=1
820	continue
	if (l.ge.n) go to 910
	read(15,*,err=980,end=310) ic, (idd(i),i=1,8), sum
	go to 981
980     write(*, 982)  ic
982	format(' read error at card #=', i5)
	stop
981	continue
	s=0 
	do 800 k=1, 8
	s=s+idd(k)
800	continue
	if (s.eq.sum) go to 801
	write(*,905) ic
905	format( '  sum check fails for card #', i5)
        do  805  k=1, 8
        idd(k)=0
805     continue
801	continue
	do 810 j=1,8
	ll=l+j-1
	x(ll)=idd(j)
810	continue
	l=l+8
	go to 820
910	continue
        else if (ifmt.eq.'s') then
	read(15,10) (x(i),i=1,n)
10      format(6e12.5)
        else 
        write(*,*) 'format must be either (v) or (s)'
        pause
        endif
c       check clipping
        call maxmin(x,n,xmax,xmin)
        if (xmax-xmin.gt.1.e7)  then
        write(*,*)  'vbb close to clipping, use lg channel'
        endif
c       check clipping end
	call  dtrd(x,n,sx,1)
        call taper (sx,n,0.05, 0.05,x)
	do 53  i=1, n
	t(i)=float(i-1)*dt
53      continue
        if(itype.eq.'s')  then
	sx(1)=0.0
        do i=2, n
        sx(i)=sx(i-1)+x(i)*dt
        end do
        do 59  i=1,n
	x(i)=sx(i)*amults
59      continue
        else if(itype.eq.'b') then
	do 62 i=1, n
	x(i)=x(i)*amultv
62      continue
        else
	write(*,*) 'data type must be either (v),  or (s)'
	pause
	endif
c        velocity data in x(i), i=1, n
c        write(*,*)  "velocity data  computed"
c        if(ifilt.eq.'f') then
c       compute preliminary ML to determine whether anti-microseism
c       filter is required or not
        do i=1, n
        xx(i)=x(i)
        end do
        call wares(xx,n,dt,tp,e,amag,sx,avd)
        call maxmin(sx,n,amax,amin)
        amax1=abs(amax)
        amax2=abs(amin)
        if (amax1.lt.amax2) amax1=amax2
	amlst=alog10(amax1*10.)+aloga0(dist)
        amlpre=amlst+amlcor
        write(22,'(f10.2)')  amlpre
        if (amlpre.lt.5.)  then
c       if preliminary ML>=5, no filter is applied
c       if preliminary ML<5, appropriate fc1 and fc2 are computed
c       and high-pass filter is applied
        fc1=1./antmcrf(amlpre)
        fc2=1./antmcrf(amlpre)
c	fc1=0.2
c	fc2=0.2
	nbt=2
        call btwfsb(x,xf,n,dt,fc1,fc2,nbt,'h')
	do 69 i=1,n
	x(i)=xf(i)
69      continue
c        write(*,*)  "high-pass filtered applied"
	endif
        do 64 i=1, n
        xx(i)=x(i)
64      continue
        call maxmin(x,n,amax,amin)
        outfil=infil(1:nbcha(infil,80))//'.vel'
        open(18,file=outfil)
        write(18,1) id1
        write(18,'(3g12.5)') amin, amax, amax-amin
        write(18,100) n,dt
        write(18,10) (x(i),i=1,n)
        close(18)
c       compute Wood-Anderson response
c        write(*,*)  "compute Wood-Anderson response"
        call wares(xx,n,dt,tp,e,amag,sx,avd)
        call maxmin(sx,n,amax,amin)
        amax1=abs(amax)
        amax2=abs(amin)
        if (amax1.lt.amax2) amax1=amax2
        outfil=infil(1:nbcha(infil,80))//'.wa'
        open(18,file=outfil)
        write(18,1) id1
        write(18,'(4g12.5)') amin, amax, amax-amin, amax1
	amlst=alog10(amax1*10.)+aloga0(dist)
	write(22,'(2f10.3)')  amlst, amlst+amlcor
	write(24,'(a15,3g12.4,f6.3)') outfil,amax,amin,amax1,amlst
        if(ntrace.eq.1)  amlr=amlst+amlcor
	amlav=amlav+amlst
        write(18,100) n,dt
        write(18,10) (sx(i),i=1,n)
        close(18)
c       compute energy
c        write(*,*)  "compute v**2(t)"
        recdur=ptimes+sptimes+durtn(amlr)-sdif
        ninteg=recdur/dt
        write(22,'(3i10)')  ninteg,  n, n-ninteg
        if(ninteg.gt.n)  then
        write(*,*) "Warning: record may not be long enough 
     2  for energy calculation"
        ninteg=n
        endif
	sx(1)=0.0
        do  i=2, ninteg
        sx(i)=sx(i-1)+x(i)**2*dt
        end do
        outfil=infil(1:nbcha(infil,80))//'.en'
	open(16,file=outfil)
        write(16,1) id1
	write(16,1) id2
	write(16,100) ninteg, dt
100     format(i10, g12.3)
        write(16,10) (sx(i), i=1, ninteg)
	call maxmin(sx,ninteg,amax,amin)
	ensum=ensum+amax
	write(22, '(g12.5)')  amax
	close(15)
	close(16)
520     continue
        end do
300     continue
        amlav=amlav/(float(ntrace))
	energy=amult*ensum
	energycor=amult*ensum*v2c
	enmag1=alog10(energy)-cen1b
	enmag1=enmag1/cen1a
        enmag2=alog10(energy)-cen2b
	enmag2=enmag2/cen2a
	enmag1cor=alog10(energycor)-cen1b
	enmag1cor=enmag1cor/cen1a
        enmag2cor=alog10(energycor)-cen2b
	enmag2cor=enmag2cor/cen2a
        write(22,'(2g12.5, 3f5.2)')ensum, energy, enmag1, enmag2, amlav
        write(22,'(2g12.5, 3f5.2,//)')ensum,energycor,enmag1cor
     2  , enmag2cor, amlav+amlcor
        write(26,'(a5,1x,a1,f10.2,f8.1,2e10.3,f6.2,e10.3,2f6.2)') 
     2   ista, itype,dist, az,ensum,energy,amlav,energycor, 
     3   enmag2cor, amlav+amlcor
500     continue
        end do
        go to 310
375     continue
	close (22)
	close(24)
        close(26)
        stop
	end
