      subroutine btwfsb(x,y,nx,dt,f1,f2,n,lhorb)
c     butterworth type filter, if lhorb="l","h",or"b", it performs
c     low-pas, high-pass, and band-pass filter, respectively
c     if lhorb="l", then f2 is the cut-off freq., and f1 is dummy
c     if lhorb="h", then f1 is the cut-off freq., and f2 is dummy
c     if lhorb="b", then f1 is low-, and f2 is high-frequency cut off.
c     n is the order, usually 3 or 4
c     x(i) is input and y(i) is output, nx is #of points and dt is dt.
c     the filter response is in w(i) in common, df is freq. increment
c     July, 1990, hiroo kanamori
      character*1 lhorb
      parameter (ndim=240000)
      real*8  a1, a2
      complex c(ndim)
      common/w/w(ndim/2), df
      dimension x(*),y(*)
      nfp=4*n
      call binfd(nx,lx1,np)
      lx1=lx1*2
         if(lx1.gt.ndim)  then
         write(*,*)  ' data too large, increase ndim in btwfsb.f '
         stop
         endif
      np=np+1
      nxp=nx+1
      lhalf=lx1/2
      lcent=lhalf+1
      do i=nxp,lx1
      x(i)=x(nx)
      enddo
      do  i=1, lx1
      c(i)=cmplx(x(i),0.0)
      enddo
      call  cool(np,c,-1.)
      df=1.0/(float(lx1)*dt)
       do  i=1, lcent
       f=float(i-1)*df
       if (lhorb.eq.'l') then
       a2=1./(1.+(f/f2)**nfp)
       w(i)=real(a2)
       else if(lhorb.eq.'h') then
       a1=(f/f1)**nfp/((f/f1)**nfp+1.)
       w(i)=real(a1)
       else if(lhorb.eq.'b') then
       a2=1./(1.+(f/f2)**nfp)
       a1=(f/f1)**nfp/((f/f1)**nfp+1.)
       w(i)=real(a1*a2)
       else 
       write(*,*) 'lhorb should be either l, h, or b'
       stop
       endif
       c(i)=c(i)*cmplx(w(i),0.0)
       enddo
      call conj(c,lcent)
      call cool(np,c,1.)
      do   i=1, nx
      y(i)=real(c(i))/float(lx1)
      enddo
      return
      end
