      function  amean(x,n)
      dimension x(*)
      s=0.
      do i=1, n
      s=s+x(i)
      end do
      amean=s/float(n)
      return
      end

      function  rms(x1,x2,n)
      dimension x1(*), x2(*)
      s=0.
      do i=1, n
      s=s+(x1(i)-x2(i))**2
      end do
      rms=sqrt(s/float(n-1))
      return
      end

      SUBROUTINE PEARSN(X,Y,N,R,PROB,Z,ierr)
      PARAMETER (TINY=1.E-20)
      DIMENSION X(N),Y(N)
      AX=0.
      AY=0.
      DO 11 J=1,N
        AX=AX+X(J)
        AY=AY+Y(J)
11    CONTINUE
      AX=AX/N
      AY=AY/N
      SXX=0.
      SYY=0.
      SXY=0.
      DO 12 J=1,N
        XT=X(J)-AX
        YT=Y(J)-AY
        SXX=SXX+XT**2
        SYY=SYY+YT**2
        SXY=SXY+XT*YT
12    CONTINUE
      R=SXY/SQRT(SXX*SYY)
      Z=0.5*ALOG(((1.+R)+TINY)/((1.-R)+TINY))
      DF=N-2
      T=R*SQRT(DF/(((1.-R)+TINY)*((1.+R)+TINY)))
      CALL BETAI(0.5*DF,0.5,DF/(DF+T**2),RES,IBERR)
      if (iberr.eq.1) then
        ierr =1 
        return 
      end if
      prob = res
      RETURN
      END

      SUBROUTINE BETAI(A,B,X,RES,IERR)
      ierr=0
      IF(X.LT.0..OR.X.GT.1.) then
        res=0. 
        ierr=1
        return
      end if
      IF(X.EQ.0..OR.X.EQ.1.)THEN
        BT=0.
      ELSE
        BT=EXP(GAMMLN(A+B)-GAMMLN(A)-GAMMLN(B)
     *      +A*ALOG(X)+B*ALOG(1.-X))
      ENDIF
      IF(X.LT.(A+1.)/(A+B+2.))THEN
        call betacf(a,b,x,tbres,iberr)
        if (iberr.eq.1) then
          ierr=1
          res=0.
          return
        end if
        res=BT*tbres/A
        RETURN
      ELSE
        call betacf(B,A,1.-X,tbres,iberr)
        if(iberr.eq.1) then
          ierr=1
          res=0.
          return
        end if
        res=1.-BT*tbres/B
        RETURN
      ENDIF
      END

      SUBROUTINE BETACF(A,B,X,res,ierr)
      PARAMETER (ITMAX=100,EPS=3.E-7)
      ierr=0
      AM=1.
      BM=1.
      AZ=1.
      QAB=A+B
      QAP=A+1.
      QAM=A-1.
      BZ=1.-QAB*X/QAP
      DO 11 M=1,ITMAX
        EM=M
        TEM=EM+EM
        D=EM*(B-M)*X/((QAM+TEM)*(A+TEM))
        AP=AZ+D*AM
        BP=BZ+D*BM
        D=-(A+EM)*(QAB+EM)*X/((A+TEM)*(QAP+TEM))
        APP=AP+D*AZ
        BPP=BP+D*BZ
        AOLD=AZ
        AM=AP/BPP
        BM=BP/BPP
        AZ=APP/BPP
        BZ=1.
        IF(ABS(AZ-AOLD).LT.EPS*ABS(AZ))GO TO 1
11    CONTINUE
      ierr=1
      res=0.
      return
1     res=AZ
      RETURN
      END

      FUNCTION GAMMLN(XX)
      REAL*8 COF(6),STP,HALF,ONE,FPF,X,TMP,SER
      DATA COF,STP/76.18009173D0,-86.50532033D0,24.01409822D0,
     *    -1.231739516D0,.120858003D-2,-.536382D-5,2.50662827465D0/
      DATA HALF,ONE,FPF/0.5D0,1.0D0,5.5D0/
      X=XX-ONE
      TMP=X+FPF
      TMP=(X+HALF)*LOG(TMP)-TMP
      SER=ONE
      DO 11 J=1,6
        X=X+ONE
        SER=SER+COF(J)/X
11    CONTINUE
      GAMMLN=TMP+LOG(STP*SER)
      RETURN
      END

      SUBROUTINE MDIAN1(X,N,XMED)
      DIMENSION X(N)
      if(n.lt.2) then
        write(*,*) 'median called with less than 2 stations'
        xmed=1
        return
      end if
      CALL SORT(N,X)
      N2=N/2
      IF(2*N2.EQ.N)THEN
        XMED=0.5*(X(N2)+X(N2+1))
      ELSE
        XMED=X(N2+1)
      ENDIF
      RETURN
      END

      SUBROUTINE SORT(N,RA)
      DIMENSION RA(N)
      L=N/2+1
      IR=N
10    CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          RRA=RA(L)
        ELSE
          RRA=RA(IR)
          RA(IR)=RA(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            RA(1)=RRA
            RETURN
          ENDIF
        ENDIF
        I=L
        J=L+L
20      IF(J.LE.IR)THEN
          IF(J.LT.IR)THEN
            IF(RA(J).LT.RA(J+1))J=J+1
          ENDIF
          IF(RRA.LT.RA(J))THEN
            RA(I)=RA(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        RA(I)=RRA
      GO TO 10
      END

      function  ichauv(x,xm,s,ant,n)
c     Chauvenet's data rejection criterion
c     if ichauv=1, consider rejection
c     if ichauv=0,  no reason for rejection
      dimension t(40), p(40)
      data t(1),t(2),t(3),t(4),t(5),t(6),t(7),t(8),t(9),t(10),
     2t(11),t(12),t(13),t(14),t(15),t(16),t(17),t(18),t(19),t(20),
     2t(21),t(22),t(23),t(24),t(25),t(26),t(27),t(28),t(29),t(30),
     2t(31),t(32),t(33),t(34),t(35)
     2/0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0,1.1,1.2,1.3,
     21.4,1.5,1.6,1.7,1.8,1.9,2.0,2.1,2.2,2.3,2.4,2.5,2.6,2.7,
     22.8,2.9,3.0,3.5,4.0,4.5,5.0/
      data p(1),p(2),p(3),p(4),p(5),p(6),p(7),p(8),p(9),p(10),
     2p(11),p(12),p(13),p(14),p(15),p(16),p(17),p(18),p(19),p(20),
     2p(21),p(22),p(23),p(24),p(25),p(26),p(27),p(28),p(29),p(30),
     2p(31),p(32),p(33),p(34),p(35)
     2/0.0,7.97,15.85,23.58,31.08,38.29,45.15,51.61,57.63,63.19,
     268.27,72.87,76.99,80.64,83.85,86.64,89.04,91.09,92.81,94.26,
     295.45,96.43,97.22,97.86,98.36,98.76,99.07,99.31,99.49,99.63,
     299.73,99.95,99.994,99.9993,99.99994/
      ichauv=0
      tm=abs((x-xm)/s)
      pm=ynterp(t,p,tm,35,0)/100.
      if (float(n)*(1.-pm).le.ant)  then
      ichauv=1
      end if
      return
      end
      
