/*   Martin-Marietta to Quanterra format utility module.
     Copyright 1994 Quanterra, Inc.
     Written by Woodrow H. Owens

Edit History:
   Ed Date      By  Changes
   -- --------- --- ---------------------------------------------------
    0 11 Jun 94 WHO Translated from gsn256hd.p
*/
#include <stdio.h>
#include <errno.h>
#include <termio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include "quanstrc.h"
#include "stuff.h"

  void undogsn (pvoid p)
    begin
      pchar p1, p2 ;
      mm_data_struc *pmds ;
      mm_comment_struc *pmcs ;
      time_quality_descriptor *ptqd ;
      compressed_record *cr ;
      commo_comment *cc ;
      mm_data_struc th ;
      comment_string_type temp ;
      header_type *hdr ;

      pmds = p ;
      pmcs = p ;
      cr = p ;
      hdr = &cr->h ;
      cc = p ;
      if ((pmds->frame_type == RECORD_HEADER_1) lor
          (pmds->frame_type == RECORD_HEADER_2))
        then
          begin
            memcpy ((pchar) &th, (pchar) pmds, sizeof(mm_data_struc)) ; /* save gsn header */
            hdr->soh = (hdr->soh and not SOH_RECEPTION_GOOD) ;
            ptqd = (pvoid) &th.time_quality ;
            if (ptqd->reception_quality_indicator >= 2)
              then
                hdr->soh = hdr->soh or SOH_RECEPTION_GOOD ;
            hdr->rate = encode_rate(th.rate) ;
            hdr->number_of_samples = th.number_of_samples ;
            hdr->samp_1 = th.firstword ;
            hdr->packet_seq = th.packet_seq ;
            hdr->clock_corr = ptqd->msec_correction ;
            memcpy ((pchar) &hdr->time_of_sample, (pchar) &th.time_of_sample, sizeof(time_array)) ;
            hdr->blockette_count = 0 ;
            hdr->header_revision = 3 ;
            p1 = (pchar) &hdr->detection_day ;
            p2 = (pchar) &hdr->ht_sp4 ;
            while (p1 <= p2)
              *p1++ = '\0' ;
          end
      else if (pmds->frame_type == COMMENTS)
        then
          begin
            memcpy ((pchar) &temp, (pchar) &pmcs->c, sizeof(comment_string_type)) ;
            memcpy ((pchar) &cc->ct, (pchar) &temp, sizeof(comment_string_type)) ;
          end
    end
