#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <dirent.h>

#define info	stdout

main (int argc, char **argv)
{
    char *dir = argv[1];
    while (1) {
	process_requests (dir);
	sleep(1);
    }
}

/************************************************************************/
/*  process_requests:							*/
/*	Process any startup or shutdown requests.			*/
/*	Return number of requests processed.				*/
/************************************************************************/
process_requests(char *cmddir)
{
    struct stat sb;
    struct dirent *dirent;
    struct passwd *pwent;
    int new_requests = 0;
    DIR *dirp;

    if ((dirp = opendir(cmddir)) != NULL) {
	char path[2048];
	while ((dirent = readdir(dirp)) != NULL) {
	    sprintf (path, "%s/%s", cmddir, dirent->d_name);
	    if (stat(path,&sb)==0 && S_ISREG(sb.st_mode)) {
		FILE *fp;
		char line[80];
		if ((fp=fopen(path,"r")) != NULL && 
		fgets (line,79,fp) != NULL) {
		    line[79] = '\0';
		    line[strlen(line)-1] = '\0';
		    pwent = getpwuid(sb.st_uid);
		    ++new_requests;
		}
		if (fp) fclose(fp);
	    }
	}
	closedir(dirp);
    }
    else {
	fprintf (info, "Unable to open dir %s\n", cmddir);
    }
    return (new_requests);
}
