.\%W% %G% %U%
.TH NETMON 1 "7 June 1995" BDSN
.SH NAME
netmon - monitor and control comserv and clients for Quanterra data acquisition
.SH SYNOPSIS
.B netmon
[\ \fB-B\fR\ ]
[\ \fB-D\fR\ ]
[\ \fB-l\fR\ ]
[\ \fB-b\fR\ ]
[\ \fB-l\fR\ ]
[\ \fB-r\fR\ ]
[\ \fB-d\ \fRn\ ]
[\ \fB-s\ |\ -t\fR\ ]
[\ \fIstation_list\fR\ ]
.br
.SH DESCRIPTION
The program
.B netmon
provides an easy interface to control the host-based data acquisition
processes (comserv and it clients) associated with Quanterra dataloggers.
It performs automatic startup and control of processes associated with the
data acquisition, and provides the ability to interactively monitor and
control these processes.
.B Netmon 
is used for 2 distinct modes to perform different functions.

In user mode mode, 
.B netmon 
reports on the status of server and client processes for one or more
Quanterra stations, based on information found in the station configuration
files.  It can queue requests to the background daemon to start or stop the
host-based processes associated with a station, and can queue a request to
the the background daemon process to reload station and network configuration
info.

In daemon mode, 
.B netmon
normally runs as a background daemon and performs automated host-based
process startup, restart, and shutdown based on the seismic network and
station configuration files.  It also performs host-based process startup
and shutdown for stations based on user requests.  You can monitor the
status of the station processes without a daemon version of 
.B netmon
running, but you cannot actually start or start processes.

.SH USER OPTIONS
.TP
.B \-v 
specifies that verbose status information for each station (server
and client processes)should be provided.
.TP
\fB\-d \fInum\fR
specifies debugging information should be displayed.  Arguments are
.nf
	1 = debug station and client status.
	2 = debug polling.
	128 = debug malloc.
.fi
Options may be added together in order to provide debugging output of
multiple items.
.TP
.B \-h
prints out a version number and a simple help message with syntax and explanation of the options.
.TP
.B \-r
queues a request to daemon process to reload and update its station and
configuration information.  This option should be used only by the seismic 
network administrator when a station has been added or removed from 
.B netmon's
control, or when configuration option changes for a station or the
daemon process.
.TP
.B \-s | \-t
specifies that the following list of stations should be started or 
terminated.  
.B Netmon
will queue the request, and the daemon copy of
.B netmon 
will perform the actual startup or shutdown of processes associated with
the specified stations.
.TP
.I station_list
is a list of of stations to be monitored, started, or stopped (depending on
the options used).
The string "*" or ALL may be used to specify all known stations.
The list may be comma-delimited (eg  WDC,CMB) or may be multiple tokens (eg WDC CMB).
If no stations are specified, ALL stations are assumed.
.SH DAEMON OPTIONS
.TP
\fB-D\fR
Run a copy of netmon in daemon mode to provide control and full-time
monitoring of the host-based processes for the Quanterra network.
There should always be one (and only one) version of 
.B netmon
running in daemon mode.
.TP  
.B \-B
runs a daemon copy of
.B netmon.
This option is normally used in conjunction with the
.B \-B
option, unless you want to debug program or have it automatically
restarted in the system inittab file.  There should be only one
daemon version of
.B netmon
running, and is usually started at system boot time.
.TP
.B \-l
directs all output from the daemon copy of 
.B netmon
to a log file NETM.log in the directory specified in the network configuration file.
This option is usually used in conjunction with the \fB-B\fR option.
.TP
.B \-b
is used only at system boot to indicate that no managed processes should be
running.  Any existing pid files created by server and client processes will
be deleted.

.SH EXAMPLES
.PD 0
.TP
netmon
prints the current status of processes for all stations.
.TP
netmon WDC,CMB
prints the status of processes for the specified station(s).
.TP
netmon -v
prints verbose output of the current status of all processes
for all stations.
.TP
netmon -v WDC
prints the verbose status of processes for the specified station(s).
.TP
netmon -s WDC
queues a request to start the processes for the specified station(s).
in the configured seismic network.
.SH FILES
.TP
/etc/network.ini
Configuration file used to provide configuration information
to 
.B netmon.
.TP
/etc/stations.ini
Configuration file that specifies all stations in the seismic network.
.TP
station.ini
A per-station configuration file that provides configuration info
for the station's server and client processes, and for
.B netmon.
.SH SEE ALSO
.LP
.I Comserv Users Guide
.LP
.I Netmon Users Guide
.LP
.I Datalog Users Guide
.SH AUTHOR
Doug Neuhauser, UC Berkeley Seimographic Station, doug@seismo.berkeley.edu
.SH BUGS

Reloading the configuration info in the daemon process while a station is
being stopped or started can result in multiple copies of a process for that
station, or can result in processes left running when they should not be
running.
