#include <iostream.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdio.h>
#include <time.h>

#include "syserr.h"
#include "mem_map.h"
#include "qtime.h"
#include "sem.h"
#include "basics.h"

int verbosity;

int main(int argc,char* argv[])
{
  time_t outtime;
  tm* mytime;
  INT_TIME curtime;

  Memory_Map mmap;
  Semaphores semf; // for deleting semaphore at end of program

  outtime = time(NULL);
  mytime = gmtime(&outtime);
  curtime = int_time_from_time_tm(mytime);

  cout << "Memory Map Started at : " 
    << time_to_str( int_time_from_time_tm(mytime),2 )<< endl;

  return(SUCCESS);
}
