/***********************************************************

File Name :
	stream_mgr.h

Programmer:
	Phil Maechling

Description:
	This defines the stream manager class. This routine reads a
	memory map configuration file (memmap.cgf) and then
	locates the position of the data header and the data array
	for its specific stream.

Limitations or Warnings:


Creation Date:
	22 March 1995

Modification History:

**********************************************************/
#include <sys/shm.h>
#include "stream_hdr.h"
#include "sem.h"

class Stream_Manager
{
  public:
    
    Stream_Manager();
   ~Stream_Manager();

    Initialize_Stream(char* memmap,char* station,char* stream);

    int Put_Sample(const INT_TIME time_of_sample, const int counts);

    int Put_Samples(const INT_TIME time_of_first_sample, 
		    const int number_of_samples,
		    const int* array_of_counts[]);


    int Get_Samples_Per_Second();

  private:

    Semaphores semaphore;

    char* start_of_memmap;

    Stream_Header* this_stream_header;

    INT_TIME Find_Next_Newest_Time(int number_of_samples,
                                   int samples_per_second);

    INT_TIME Find_Next_Oldest_Time(int number_of_samples,
                                   int samples_per_second);

    int Samples_to_Move_Oldest_Time(int number_of_new_samples);

    void Move_Sample_Ptrs_One_Sample();

    INT_TIME new_time;
    INT_TIME old_time;

};
