/***********************************************************

File Name :
	stream_hdr.h

Programmer:
	Phil Maechling

Description:
	This is the shared stream description between the writer
	and the reader processes.

Limitations or Warnings:


Creation Date:
	22 March 1995

Modification History:

**********************************************************/
#ifndef Stream_HeaderH
#define Stream_HeaderH

#include <iostream.h>
#include "sample.h"


struct Stream_Header
{

  char          station[8];
  char          stream[8];	
  int           samples_per_second;
  int           seconds_in_memory;
  int           stream_samples_in_memory;

  unsigned int  offset_to_first_sample;
  unsigned int  offset_to_last_sample;

  Sample_Time   time_of_newest_sample;
  Sample_Time   time_of_oldest_sample;

  unsigned int  offset_to_newest_sample;
  unsigned int  offset_to_oldest_sample;

};

#endif
