/***********************************************************

File Name :
	sem.cc

Programmer:
	Phil Maechling

Description:
	This is the ccimplementation for a simple semaphore system.
	It is to be used to protect the shared memory area used to
	distrubute data in real-time.

Limitations or Warnings:


Creation Date:
	27 March 1995

Modification History:

**********************************************************/
#include <iostream.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sem.h"
#include "syserr.h"
#include "sample.h"
#include "basics.h"

Semaphores::Semaphores()
{

 int retnum;

 //
 // All client processed need the semaphore key
 //

 Get_Semaphore_Key();

 
 retnum = semget(sem_key,0,0);

  if (retnum == -1)
  {

    sem_id = Semaphore_Key_to_Id(sem_key);
    retnum = Initialize_Semaphore(sem_id);
    if (retnum == -1)
    {
      fatalsyserr("Error initializing semaphore");
    }
  }
  else
  {
   sem_id = retnum;
  }
}


Semaphores::~Semaphores()
{


}

int Semaphores::Semaphore_Key_to_Id(key_t key)
{
  int sid;
  if ((sid = semget((key_t)key,1,0666|IPC_CREAT)) == -1)
  {
    syserr("Error converting semp key to id");
  }
  return(sid);
}


void Semaphores::Acquire_Semaphore()
{
 
 Semcall(Semaphores::sem_id,-1);

}

void Semaphores::Release_Semaphore()
{

 Semcall(Semaphores::sem_id,1);
}


void Semaphores::Semcall(int smid,int op)
{

  struct sembuf sb;
  
  sb.sem_num = 0;
  sb.sem_op  = op;
  sb.sem_flg = 0;
  
  if(semop(smid,&sb,1) == -1)
  {
    syserr("Error in class semaphore. return == -1");
  }
}


int Semaphores::Initialize_Semaphore(int semid)
{
  int retnum;
  union semun 
  {
   int val;
   struct semid_ds *buf;
   ushort *array;
   } tsemun;

  tsemun.val = 1;

  retnum = semctl(semid,0,SETVAL,tsemun); 

  if (retnum == -1)
  {
    return(-1);
  }
 
  return(1);
}



void Semaphores::Delete_Semaphore()
{

  int retnum;

  cout << "Ready to release semaphores " << endl;
  retnum = semctl(Semaphores::sem_id,0,IPC_RMID);
  if (retnum == -1)
  {
    fatalsyserr("Error releasing semaphore");
  }
  cout << "Semaphore Released" << endl;
}


void Semaphores::Get_Semaphore_Key()
{
  char* fname;
  FILE* filep;  
  char  keyword[20];
  char  colan[20];
  int   scanres;
  int   compres;
  char* defaultname = "/home/rtem/cda/memmap.cfg";
  int   noerr;
  int   thiskey;

  fname = getenv("MEM_MAP"); 
   
  if (fname == NULL)
  {
    fname = defaultname;
  }

  filep = fopen(fname,"r");
  
  if (filep == NULL)
  {
    cout << "Unable to open Memory_Map configuration file" << endl;
    cout << "Tried file : " << fname << endl;
    exit(-1);
  }

  noerr = TRUE;

  while(!feof(filep) && (noerr))
  {

    scanres = fscanf(filep,"%s %s %d",keyword,colan,&thiskey);
    if (scanres != 3)
    {
      cout << "Error scanning memmap file : " << fname << endl;
      cout << "mem_key field not found. " << endl;
      noerr = FALSE;
      continue;
    }

    compres = strcmp(keyword,"mem_key");
    if (compres != 0)
    {
      cout << "Error scanning memmap file : " << fname << endl;
      cout << "mem_key field not found. " << endl;
      noerr = FALSE;
      continue;
    }

    if (thiskey < 1)
    { 
      cout << "Semaphore key too low :  " << thiskey << endl;
      noerr = FALSE;
    }
    else
    {
      sem_key = (key_t) thiskey;
      break;
    }
  }   // end while reading not end of entire file

  fclose(filep);
   
  if (noerr)
  {
    return;
  }
  else
  {
    cout << "Exiting on configuration scan error" << endl;
    exit(-1);
  }
}
