/***********************************************************

File Name :
	mem_map.h

Programmer:
	Phil Maechling

Description:
	This defines the memory map class. This routine reads the
	memory map configuration file (memmap.cgf) and then
	creates a shared memory area based on configuration
	file. The constructor creates the shared memory area,
	and the destructor removes it.

Limitations or Warnings:


Creation Date:
	22 March 1995

Modification History:

**********************************************************/
#include <sys/shm.h>

class Memory_Map
{
  public:

  Memory_Map();
 ~Memory_Map();
  Delete_Memory_Area(); 
  char* Start_of_Memory_Area();

  private:

  int Get_Memory_Key();
  int Determine_Size_of_Memory_Area();
  int Populate_Header();
  
  key_t mem_key;
  int shmid;  
  char* start_of_memmap;
  int total_streams_in_list;
  int total_samples_in_array;

};
