#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include "getdata.h"
#include "syserr.h"
#include "qtime.h"
#include "getdata.h"
#include <string.h>

int main(int argc, char* argv[])
{
  GetData get_data;
  INT_TIME starttime;
  INT_TIME  outtime;
  int number_of_samples;
  int retarray[MAX_OUTPUT_SAMPLES];
  int duration; 
  int res;
  int sps;

  if(argc<2)
  {
    cout << "Usage: try STATION STREAM" << endl;
    exit(-1);
  }

  struct timeval tp;

  res = gettimeofday(&tp,NULL);

  // backup 60 seconds

  tp.tv_sec = tp.tv_sec - 120;

  starttime = int_time_from_timeval(&tp);

  cout << "Getting Station: " << argv[1] << " Stream : " <<
    argv[2] << " Time : " << time_to_str(starttime,0) << endl;
   
  duration = 60;


  res = get_data.get_segment(argv[1],argv[2],starttime,
   duration,&sps,&outtime,&number_of_samples,retarray);

  if (res != FAILURE)
  { 
    cout << "Outtime " << time_to_str(outtime,1) << endl;
    cout << "Number of samples retrieved : " << number_of_samples << endl;
    cout << "Samples per second : " << sps << endl;

    for(int i=0;i<number_of_samples;i++)
    {
      cout << retarray[i] << " ";
      if (0 == (i%10))
      {
        cout << endl;
      }
    }
    cout << endl;
  } 
  else
  {
    cout << "Requested data not available in cda"<< endl;
  }

  return(1);
}
