/***********************************************************

File Name :
	getdata.h

Programmer:
	Phil Maechling

Description:
	This declares the GetData retreival class. The routines
	in this class can retreive data from the shared memory area.

Limitations or Warnings:


Creation Date:
	11 April 1995

Modification History:

**********************************************************/
#ifndef GetData_H
#define GetData_H

#include "stream_hdr.h"
#include "mem_map.h"
#include "sem.h"
#include "qtime.h"
#include "qclass.h"

const int MAX_OUTPUT_SAMPLES=30000; // 5 minutes of 100 sps data

class GetData
{
  public:
    
    GetData();
   ~GetData();

   int get_segment(
         char*     sta, 
         char*     strm,
         INT_TIME  reqtime,
         int       duration,
         int*      sps, 
         INT_TIME* outtime,
         int*      number_of_out_samples,
	 int       retarray[]);				


  private:

    Memory_Map mmap;
    Semaphores semaphore;
    QClass qt;
    char* start_of_memmap;
    Stream_Header* this_stream_header;
    int number_of_streams;
    Sample* current_sample;
    unsigned int current_sample_offset;

    int FindStationStreamHeader(char* station, char* stream);
    void MoveCurrentSamplePtrOneSample();
};

#endif
