/***********************************************************

File Name :
	cssubs.C

Programmer:
	Phil Maechling

Description:
	This contains subroutines which call c++ routines which
        interface to the cda code.

Creation Date:
	29 Aug 1995

Modification History:


Usage Notes:


**********************************************************/
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <stdio.h>
#include "mem_map.h"
#include "sample.h"
#include "basics.h"
#include "cssubs.h"


int initialize_cda(char *sname,	
		   char* s1, char* s2, char* s3,
		   char* s4, char* s5, char* s6)
{
  int res;

  res = Find_Station_Streams(sname,s1,s2,s3,s4,s5,s6);


  if(res != SUCCESS)
  {
   cout << "Error find streams. " << endl;
   return(FAILURE);
  }
 
  if(strcmp(s1,"")== 0)
  {
    cout << "Couldn't find channel 1 in config file" << endl;
    return(FAILURE);
  }
  else if(strcmp(s2,"")==0)
  {
    cout << "Couldn't find channel 2 in config file" << endl;
    return(FAILURE);
  }
  else if (strcmp(s3,"")==0)
  {
    cout << "Couldn't find channel 3 in config file" << endl;
    return(FAILURE);
  } 
  else if(strcmp(s4,"")== 0)
  {
    cout << "Couldn't find channel 4 in config file" << endl;
    return(FAILURE);
  }
  else if(strcmp(s5,"")==0)
  {
    cout << "Couldn't find channel 5 in config file" << endl;
    return(FAILURE);
  }
  else if (strcmp(s6,"")==0)
  {
    cout << "Couldn't find channel 6 in config file" << endl;
    return(FAILURE);
  } 


  return(SUCCESS);
}


int Find_Station_Streams(char* station,char* s1,char* s2,char* s3,
					char* s4, char* s5, char* s6)
{
  char* fname;
  FILE* filep;  
  char  keyword[20];
  char  colan[20];
  int   scanres;
  int   compres;
  char* defaultname = "/home/rtem/cda/memmap.cfg";
  int   noerr;
  int   thiskey;
  int   ismore;

  fname = getenv("MEM_MAP"); 
   
  if (fname == NULL)
  {
    fname = defaultname;
  }

  filep = fopen(fname,"r");
  
  if (filep == NULL)
  {
    cout << "Unable to open Memory Map configuration file" << endl;
    cout << "Tried file : " << fname << endl;
    return(FAILURE);
  }

  noerr = TRUE;
  ismore = TRUE;

  while(!feof(filep) && (noerr)&& (ismore) )
  {

    scanres = fscanf(filep,"%s %s %d",keyword,colan,&thiskey);
    if (scanres != 3)
    {
      cout << "Error scanning memmap file : " << fname << endl;
      cout << "mem_key field not found. " << endl;
      noerr = FALSE;
      continue;
    }

    compres = strcmp(keyword,"mem_key");
    if (compres != 0)
    {
      cout << "Error scanning memmap file : " << fname << endl;
      cout << "mem_key field not found. " << endl;
      noerr = FALSE;
      continue;
    }

    if (thiskey < 1)
    { 
      cout << "Memory key too low :  " << thiskey << endl;
      noerr = FALSE;
    }
    else
    {
      cout << "Shared memory key found : " << thiskey << endl;
    }

  // Now go through station list look for the first three streams
  // associated with this station name. Assigned the streams to channels
  // in the order that they are found.
  //

    int chancount = 0;
    while(!feof(filep) && (noerr) && (ismore) )
    {
      int line1,line2,line3,line4;
      char sta[8];
      char str[8];
      int sps;
      int sim;

      line1 = fscanf(filep,"%s %s %s",keyword,colan,sta);
      line2 = fscanf(filep,"%s %s %s",keyword,colan,str);
      line3 = fscanf(filep,"%s %s %d",keyword,colan,&sps);
      line4 = fscanf(filep,"%s %s %d",keyword,colan,&sim);
    
      // all four line scans should get three items
      // error if they do not

      if ( (line1 !=3) || (line2 != 3) || (line3 != 3) ||
            (line4 != 3) )
      {
        if(feof(filep))
        {
          continue;
        }
        else
        {  
          noerr = FALSE;
          continue;
        }
      }
      else
      {
        if(strcmp(station,sta) ==0)
        {
          ++chancount;
          switch(chancount)
          {
            case(1):
            {  
             strcpy(s1,str);
             cout << "Found stream : " << sta << " : " << str <<  endl;
             cout << "Assigned to channel : " << chancount << endl;
             break;
            }
            case(2):
            {  
             strcpy(s2,str);
             cout << "Found stream : " << sta << " : " << str <<  endl;
             cout << "Assigned to channel : " << chancount << endl;
             break;
            }
            case(3):
            {  
             strcpy(s3,str);
             cout << "Found stream : " << sta << " : " << str <<  endl;
             cout << "Assigned to channel : " << chancount << endl;
             break;
            }
            case(4):
            {  
             strcpy(s4,str);
             cout << "Found stream : " << sta << " : " << str <<  endl;
             cout << "Assigned to channel : " << chancount << endl;
             break;
            }
            case(5):
            {  
             strcpy(s5,str);
             cout << "Found stream : " << sta << " : " << str <<  endl;
             cout << "Assigned to channel : " << chancount << endl;
             break;
            }
            case(6):
            {  
             strcpy(s6,str);
             cout << "Found stream : " << sta << " : " << str <<  endl;
             cout << "Assigned to channel : " << chancount << endl;
             ismore = FALSE;
             break;
            } //end case
          } // end switch
        }// end if station matches 
      } //end if line was read properly
    } // end while counting up station totals
  }   // end while reading not end of entire file

  fclose(filep);
   
  if (noerr)
  {
    cout << "Configuration scan completed " << endl;
    return(SUCCESS);
  }
  else
  {
    cout << "Exiting on configuration scan error" << endl;
    return(FAILURE);
  }

}
