#!/usr/local/bin/perl

########################################################################
#	print_syntax	- print syntax and exit.
########################################################################
sub print_syntax {
    local($cmdname) = @_;
    $cmdname = $1 if ($cmdname =~ m|^.*/([^/]+)$|);
    printf	
"$cmdname - Convert a PostScript file to a GIF file.
Syntax:
$cmdname   -h [-r res] [ps_file [gif_file]]
where:
    -h		Help - prints this help message.
    -v		Verbose mode - show actual conversion command.
    -r res	Specifies the output resolution of the GIF file.
		Default is 72, which provides a identical size output.
		Res can be a single number (72) or NxM (eg 60x40) for 
		different X and Y resolutions.  The smaller the number,
		the smaller the output.
    ps_file	Is the optional name of the PostScript file to convert.
		If no file is specified, input is read from stdin.
    gif_file	Is the name of the output gif file. 
		If no file is specified, output is written to stdout.
		If you want to specify an output file, you must specify
		an input file.  The input file may be '-' to indicate stdin.
";
    exit(0);
}

########################################################################
#	Initialization
########################################################################
{
    require "getopts.pl";
    $prog = "gs -sDEVICE=gif8";
    $res = 72;
    $in = "-";
    $out = "-";
    &Getopts ('hvr:');
    &print_syntax($0) if ($opt_h);
    $verbose = $opt_v;

    $res = $opt_r if ($opt_r ne "");

    die "Too many arguments" if ($#ARGV > 1);
    $out = $ARGV[1] if ($#ARGV > 0);
    {
	$in = " - < $ARGV[0]", last if ($#ARGV >= 0 && $ARGV[0] ne "-");
    }
    $cmd = "$prog -r$res -q -sOutputFile=$out $in";
    print (STDERR $cmd, "\n") if ($verbose);
    system ($cmd);
}
