.\$Id: msunpack.man,v 1.1 1996/02/02 18:17:04 doug Exp $ 
.TH MSUNPACK 1 "2 Feb 1996" BDSN
.SH NAME
msunpack - Unpack a packed miniSEED file such as Quanterra LOG, TIM, DET, or CAL files
.SH SYNOPSIS
.B msunpack
[\ \fB\-b\ \fIblksize\fR ]
[\ \fB\-p\ \fIpacksize\fR ]
[\ \fB\-d\ \fInum\fR\ ]
[\ \fB\-h\fR\ ]
[\ \fIinput_file\ [\ output_file\fR\ ]]
.br
.SH DESCRIPTION
The program
.B msunpack
will unpack packed miniSEED files that were created by the Quanterra
\fBretrieve\fR program.  The Quanterra \fBretrieve\fR program creates packed
miniSEED files for non-timeseries data, such as MSG files (LOG channel), DET
(event detection blockettes) files, TIM (ACE timing channel) files, and CAL
(calibration blockettes) files.  Each packed miniSEED record in the input is
expanded into a full miniSEED record with the specified output blocksize,
and written to the output stream.  The output blocksize may be any valid
miniSEED blocksize that is large enough to hold the largest packed
miniSEED record encounted in the input stream.

.SH OPTIONS
.TP
\fB\-b \fIblksize\fR
specifies the blocksize of the output file.  The blocksize may be any
valid miniSEED blocksize (ie a power of 2) between 512 and 4K bytes.
The default blocksize if 4K.  The blocksize may either be specified as
the number of bytes (eg 4096) or as a number of K bytes (eg 4K).
.TP
\fB\-b \fIpacksize\fR 
specifies the unit size of the input packed miniSEED records.  Each packed
record is a multiple of the packsize, but each packed record may be a
different size.  The Quanterra \fBretrieve\fR program will pack as many
packed records as will fit into an input block.  Packed records may not span
an input block, and the remainder of any input block should be filled with
NULLs.  The packsize may be any valid miniSEED blocksize (ie a power of 2)
between 512 and 4K bytes.  The default packsize is 128.  The packsize may
either be specified as the number of bytes (eg 4096) or as a number of K
bytes (eg 4K).  
.sp
The Quanterra \fBretrieve\fR program creates packed miniSEED files with an
input blocksize of 4096 bytes, but the \fBmsunpack\fR should function
properly with any valid miniSEED input blocksize.
.TP
\fB\-d \fInum\fR
specifies debugging information should be displayed.  Current debugging
options are:
.nf
.ta 1.0i
	1 = packet info
.fi
.ad
Multiple debugging options can be specified by adding the appropriate values
together.
.TP
.B \-h
print out a simple help message with syntax and explaination of the options.
.TP
\fIinput_file\fR
specifies the optional input file to be unpacked.  If no file is specified, 
input is read from stdin.
.TP
\fIoutput_file_n\fR
specifies the optional output files to which the unpacked miniSEED records
will be written.  If no output file is specified, the miniSEED records will
be written to stdout.  You may not specify an output file without specifying
an input file.
.SH NOTES
The 
.B msexpand
program may be used as a filter to expand console message (LOG channel)
files or timing message (ACE channel) files that were retrieved with
Quanterra's dialup \fBretrieve\fB program before processing them with nlog.
You can pipe the output of
.B msexpand
directly into
.BR nlog ,
and never have to save the large intermediate miniSEED file.
.SH EXAMPLES
1.  Unpack a packed console log file and convert it to an ascii test file using nlog.
.nf
	msunpack wdc.log.packed | nlog > wdc.log.text
.fi
2.  Unpack a packed timing log into a miniSEED file with 512-byte blksize.
.nf
	msunpack wdc.tim.packed WDC.BK.ACE.T.1996.031
.ad

.SH BUGS
Only only byte order recognized for the miniSEED headers is big-endian (eg
SPARC or Motorola word order). 
.SH AUTHOR
Doug Neuhauser, UC Berkeley Seismographic Station, doug@seismo.berkeley.edu.
