package Waveform::swc;

require 5.005_62;
use strict;
use warnings;

require Exporter;
use AutoLoader qw(AUTOLOAD);

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Waveform::swc ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
wf_request		
ch_request		
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);
our $VERSION = '1.04';


# Preloaded methods go here.

sub wf_request
{
    my ($n,$s,$c,$l,$start,$end,$id,$iddomain,$format,$trimflag) = @_;
    $l = "-" if ((! defined $l) || "$l" eq "");
    $iddomain = "NONE" if ($iddomain eq "");
    $id = 0 if ($id eq "");
    $start = "NODATE" if ($start eq "" && $id != 0);
    $end   = "NODATE" if ($end   eq "" && $id != 0);
    $format = uc($format);
    $trimflag = uc($trimflag);
    return (undef) if (! ($format =~ /^(MSEED)$/));
    return (undef) if (! ($trimflag =~ /^(EXACT)|(RECORD)$/));
    return (undef) if ($n eq "" or $s eq "" or $c eq "" or $l eq "" or
			  $start eq "" or $end eq "" or 
			  $id eq "" or $iddomain eq "");
    my ($request) = "GET_WAVEFORM $n $s $c $l $start $end $id $iddomain $format $trimflag\015\012";
    return ($request);
}

sub ch_request
{
    my ($n,$s,$c,$l,$start,$end,$id,$iddomain) = @_;
    $l = "-" if ((! defined $l) || "$l" eq "");
    $iddomain = "NONE" if ((! defined $iddomain) || $iddomain eq "");
    $id = 0 if ((! defined $id) || $id eq "");
    $start = "NODATE" if ($start eq "" && $id != 0);
    $end   = "NODATE" if ($end   eq "" && $id != 0);
    return (undef) if ($n eq "" or $s eq "" or $c eq "" or $l eq "" or
			  $start eq "" or $end eq "" or
			  $id eq "" or $iddomain eq "");
    my ($request) = "GET_INVENTORY $n $s $c $l $start $end $id $iddomain\015\012";
    return ($request);
}

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

Waveform::swc - Perl extension for generating request to a simple waveform
client call to a simple waveform server.

=head1 SYNOPSIS

  use Waveform::swc;
  $request = Waveserver::swc::wf_request($n,$s,$c,$l,$start,$end,$id,$iddomain,$format,trimflag);
  $request = Waveserver::swc::ch_request($n,$s,$c,$l,$start,$end,$id,$iddomain);

=head1 DESCRIPTION

Perl module to generate simple waveform client request to send to
simple waveform server.

=head2 EXPORT

None by default.


=head1 AUTHOR

Doug Neuhauser, UC Berkeley, doug@seismo.berkeley.edu

=head1 SEE ALSO

perl(1).

=cut
