#! /usr/bin/env perl
# Perl script to install swc.
# Run as:
#	perl INSTALL_SWC.pl
#

exit main();

sub main
{
	my $qtime_module_dir =	'Qtime-0.09';
	my $swc_module_dir =	'Waveform-swc-1.04';
	my $swc_dir =		"swc-src";

	&untar ("$qtime_module_dir");
	&untar ("$swc_module_dir");
	&untar ("$swc_dir");

	my $need_qtime_module = &check_module("Qtime") != 0;
	my $need_swc_module = &check_module("Waveform::swc") != 0;
	my ($module_prefix);

	# Get installation directory for the perl modules.
	print (
	"######################################################################\n",
	"The installation will install / update the following perl modules:\n",
	"    Qtime\n",
	"    Wavefor::swc\n",
 	"Specify the installation directory for the lib and man files for these modules.\n",
	"For system-wide installation of the perl modules, just hit <return>.\n",
	"For personal installation, I recommend ~ or ~/perllib.\n",
	"You may use '~' to refer to your home directory.\n\n",
	"Enter perl module installation directory: "
	);
	chomp ($module_prefix = <STDIN>);
	$module_prefix = "" if ($module_prefix =~ /^\s*$/);
	print "\n";

	# Install the perl modules.
	my(@libdir,%libdir);
	@libdir = &install_module ($qtime_module_dir, $module_prefix);
	if (@libdir != 0 ) {
	    for my $lib (@libdir) { 
		$libdir{"$lib"} = 1;
	    }
	}

	@libdir = &install_module ($swc_module_dir, $module_prefix);
	if (@libdir != 0 ) {
	    for my $lib (@libdir) { 
		$libdir{"$lib"} = 1;
	    }
	}

	my($uselibdir) = "";
	my @dirs = keys %libdir;
	$uselibdir = '"' . join (" ", @dirs) . '"';

	my($LEAPSECONDS) = &install_leapseconds ();
	&install_swc ($swc_dir, $uselibdir, $LEAPSECONDS);
	return 0;
}

sub install_swc {
	my ($dir, $uselibdir, $LEAPSECONDS) = @_;
	my ($cmd, $bindir);
	print (
	"######################################################################\n",
	"Specify the installation directory for the swc command.\n",
	"To specify the default system-wide directory /usr/local/bin, just hit <return>.\n",
	"You should specify a directory that is in your execution path.\n",
	"You may use '~' to refer to your home directory (eg ~/bin)\n\n",
	"Enter swc installation directory: ");
	chomp ($bindir = <STDIN>);
	$bindir = "" if ($bindir =~ /^\s*$/);
	$bindir =~ s|\~|$ENV{HOME}| if ($bindir =~ /^~/);
	print "\n";

	$cmd = "mkdir -p $bindir";
	if ($bindir ne "" && ! -d  $bindir) {
		print "$cmd\n";
		system($cmd) == 0 or die ("Error $? running $cmd\n");
	}
	$cmd = "cd $dir; make clean; make";
	$cmd .= " USELIBDIR=$uselibdir" if ($uselibdir ne "");
	$cmd .= " LEAPSECONDSFILE=$LEAPSECONDS" if ($LEAPSECONDS ne "");
	print "$cmd\n";
	system($cmd) == 0 or die ("Error $? running $cmd\n");
	$cmd = "cd $dir; make install";
	$cmd .= " BINDIR=$bindir" if ($bindir ne "");
	print "$cmd\n";
	system($cmd) == 0 or die ("Error $? running $cmd\n");
	$cmd = "cd $dir; make install_init";
	print "$cmd\n";
	system($cmd) == 0 or die ("Error $? running $cmd\n");
}

sub install_leapseconds
{
	my ($cmd, $libdir);
	# Check to see if a leapseconds file is installed.
	my($dflt_leapseconds) = "/usr/local/lib/leapseconds";
	print (
	"######################################################################\n",
	"A leapseconds file is used by sws and the Qtime perl module\n",
	"to properly compute time durations.\n\n");

	printf ("$dflt_leapseconds file already installed.\n\n"), return ("")
		if (-f $dflt_leapseconds);
	$LEAPSECONDS = $ENV{LEAPSECONDS};
	printf ("$LEAPSECONDS file already installed.\n\n"), return ("")
		if ($LEAPSECONDS ne "" && -f $LEAPSECONDS);
	print (
	"Specify the installation directory for the leapseconds.\n",
	"To specify the default system-wide directory /usr/local/lib, just hit <return>.\n",
	"You may use '~' to refer to your home directory (eg ~/lib)\n\n",
	"Enter leapseconds installation directory: ");
	chomp ($libdir = <STDIN>);
	$libdir = "" if ($libdir =~ /^\s*$/);
	$libdir =~ s|\~|$ENV{HOME}| if ($libdir =~ /^~/);
	print "\n";

	$cmd = "mkdir -p $libdir";
	if ($libdir ne "" && ! -d  $libdir) {
		print "$cmd\n";
		system($cmd) == 0 or die ("Error $? running $cmd\n");
	}
	$LEAPSECONDS = "$libdir/leapseconds";
	$cmd = "cp leapseconds $LEAPSECONDS";
	print "$cmd\n";
	system($cmd) == 0 or die ("Error $? running $cmd\n");
	print "\n";
	return ("$LEAPSECONDS");
}

sub install_module
{
	my ($dir,$prefix) = @_;
	my ($cmd, $libdir);
	$cmd = "cd $dir; perl Makefile.PL";
	$cmd .= " PREFIX=$prefix" if ($prefix ne "");
	print "$cmd\n";
	system($cmd) == 0 or die ("Error $? running $cmd\n");

	$cmd = "cd $dir; make";
	print "$cmd\n";
	system($cmd) == 0 or die ("Error $? running $cmd\n");

	$cmd = "cd $dir; make install";
	print "$cmd\n";
	system($cmd) == 0 or die ("Error $? running $cmd\n");

	if ($prefix ne "") {
		my $test = "./Makefile.test";
		$cmd = "cp $dir/Makefile $test";
		print "$cmd\n";
		system($cmd) == 0 or die ("Error $? running $cmd\n");
		open (TEST, ">>$test") || die ("Error appending to file $test\n");
		print (TEST "xxxx:\n");
		print (TEST "\t\@echo \$(INSTALLSITELIB)\n");
		print (TEST "\t\@echo \$(INSTALLSITEARCH)\n");
		close (TEST);
		$cmd = "make -f $test xxxx";
		chomp(@libdir = `$cmd`);
		unlink($test);
		die ("Error $? running $cmd\n") if ($?);
	}
	print ("libdir=", join(" ", @libdir), "\n");
	print ("\n");
	return (@libdir);
}

sub check_module 
{
	my ($module) = @_;
	my ($cmd) = "perl -e \"use $module;\" >/dev/null 2>&1";
	system ($cmd);
	return $?
}

sub untar {
	my ($dir) = @_;
	my ($tarfile) = "$dir.tar.gz";
	die ("Error - cannot find tar file $tarfile\n") unless (-d $dir || -e $tarfile);
	if (! -d $dir) {
		my $cmd = "gunzip -c $tarfile | tar xf -";
		print ("Untarring $dir ...\n");
		system($cmd) == 0 || die ("Error $? running: $cmd\n");
	}
}
