# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..47\n"; }
END {print "not ok 1\n" unless $loaded;}
use Qtime;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

select(STDERR); $| = 1;
select(STDOUT); $| = 1;

$ymdfmt = "Time is: %04d/%02d/%02d,%02d:%02d:%02d.%06d\n";
$yjfmt  = "Time is: %04d.%03d,%02d:%02d:%02d.%06d\n";
$itfmt  = "Time is: %d %d %d\n";

$n = 2;
$qt = Qtime::new();
print "qt = $qt\n";
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 3;
$qt1 = Qtime::new($qt);
print "qt = $qt\n";
$ok = (Qtime::tdiff($qt, $qt1) == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
#:: Initialization values used for tests below.
#:: Must be internally consistent.

$iyear = 2000; $imonth = 6; $iday = 13; $ihour = 12; $iminute = 34; $isecond = 56; $iusec = 789012;
$idoy = 165;
$idoysec = $ihour*$SECS_PER_HOUR + $iminute*$SECS_PER_MINUTE +$isecond;
$iysec = ($idoy-1)*$SECS_PER_DAY + $idoysec;

########################################################################
#:: Set time with mtime, check it.

$n = 4;
$qt = Qtime::set_mtime($iyear,$imonth,$iday,$ihour,$iminute,$isecond,$iusec);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 5;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 6;
($oyear,$odoy,$ohour,$ominute,$osecond,$ousec) = Qtime::jtime($qt);
$ok = ($iyear == $oyear && $idoy == $odoy && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 7;
($oyear,$osecond,$ousec) = Qtime::itime($qt);
$ok = ($iyear == $oyear && $iysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf ($itfmt,$oyear,$osecond,$ousec);
printf "$ok %d\n", $n;

$n = 8;
($oyear,$odoy,$osecond,$ousec) = Qtime::doytime($qt);
$ok = ($iyear == $oyear && $idoy == $odoy && $idoysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
#:: Set time with jtime, check it.

$n = 9;
$qt = Qtime::set_jtime($iyear,$idoy,$ihour,$iminute,$isecond,$iusec);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 10;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 11;
($oyear,$odoy,$ohour,$ominute,$osecond,$ousec) = Qtime::jtime($qt);
printf ($yjfmt,$oyear,$odoy,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $idoy == $odoy && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 12;
($oyear,$osecond,$ousec) = Qtime::itime($qt);
$ok = ($iyear == $oyear && $iysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 13;
($oyear,$odoy,$osecond,$ousec) = Qtime::doytime($qt);
$ok = ($iyear == $oyear && $idoy == $odoy && $idoysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
#:: Set time with itime, check it.

$n = 14;
$qt = Qtime::set_itime($iyear,$iysec,$iusec);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 15;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 16;
($oyear,$odoy,$ohour,$ominute,$osecond,$ousec) = Qtime::jtime($qt);
printf ($yjfmt,$oyear,$odoy,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $idoy == $odoy && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 17;
($oyear,$osecond,$ousec) = Qtime::itime($qt);
$ok = ($iyear == $oyear && $iysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 18;
($oyear,$odoy,$osecond,$ousec) = Qtime::doytime($qt);
$ok = ($iyear == $oyear && $idoy == $odoy && $idoysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
#:: Set time with doytime, check it.

$n = 19;
$qt = Qtime::set_doytime ($iyear,$idoy,$idoysec,$iusec);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 20;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 21;
($oyear,$odoy,$ohour,$ominute,$osecond,$ousec) = Qtime::jtime($qt);
printf ($yjfmt,$oyear,$odoy,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $idoy == $odoy && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 22;
($oyear,$osecond,$ousec) = Qtime::itime($qt);
$ok = ($iyear == $oyear && $iysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 23;
($oyear,$odoy,$osecond,$ousec) = Qtime::doytime($qt);
$ok = ($iyear == $oyear && $idoy == $odoy && $idoysec == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
#:: isecond set and retrieve.

$n = 24;
$status = Qtime::set_isecond($qt, $iysec);
$ok = ($status == $iysec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 25;
$osecond = Qtime::isecond($qt);
$ok = ($iysec == $osecond) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 26;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
#:: year set and retrieve.

$n = 27;
$status = Qtime::set_year($qt, 2001);
$ok = ($status == 2001) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 28;
$oyear = Qtime::year($qt);
$ok = ($oyear == 2001) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
#:: month set and retrieve.

$n = 29;
$status = Qtime::set_month($qt, 7);
$ok = ($status == 7) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 30;
$omonth = Qtime::month($qt);
$ok = ($omonth == 7) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
	
########################################################################
#:: day set and retrieve.

$n = 31;
$status = Qtime::set_day($qt, 21);
$ok = ($status == 21) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 32;
$oday = Qtime::day($qt);
$ok = ($oday == 21) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
	
########################################################################
#:: hour set and retrieve.

$n = 33;
$status = Qtime::set_hour($qt, 15);
$ok = ($status == 15) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 34;
$ohour = Qtime::hour($qt);
$ok = ($ohour == 15) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
	
########################################################################
#:: minute set and retrieve.

$n = 35;
$status = Qtime::set_minute($qt, 26);
$ok = ($status == 26) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 36;
$ominute = Qtime::minute($qt);
$ok = ($ominute == 26) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
	
########################################################################
#:: second set and retrieve.

$n = 37;
$status = Qtime::set_second($qt, 37);
$ok = ($status == 37) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 38;
$osecond = Qtime::second($qt);
$ok = ($osecond == 37) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
	
########################################################################
#:: usec set and retrieve.

$n = 39;
$status = Qtime::set_usec($qt, 485960);
$ok = ($status == 485960) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 40;
$ousec = Qtime::usec($qt);
$ok = ($ousec == 485960) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
	
########################################################################
print "Checking time addition and comparisons\n";

$n = 41;
$qt = Qtime::set_time("1997/06/29,23:15");
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);

$qt = Qtime::add_time($qt, $SECS_PER_HOUR, 0);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);

$n = 42;
$i1 = 7200000000;
$qt1 = Qtime::add_dtime($qt, $i1);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt1);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
printf "$ok %d\n", $n;

$n = 43;
$tdif = Qtime::tdiff($qt1, $qt);
$ok = ($tdif == $i1) ? "ok" : "NOT ok";
printf "$ok %d tdif = %.0lf\n", $n, $tdif;

########################################################################
print "Checking leap seconds, add 1 hour\n";

$n = 44;
$qt = Qtime::set_time("1997/06/30,23:15");
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);

$n = 45;
$qt1 = Qtime::new($qt);
$ohour = Qtime::hour($qt1) + 1;
$status = Qtime::set_hour($qt1, $ohour);
$ok = ($status == $ohour) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 46;
$tdif = Qtime::tdiff($qt1, $qt);
$idif = ($SECS_PER_HOUR+1) * $USECS_PER_SEC;
$ok = ($tdif == $idif) ? "ok" : "NOT ok";
printf "$ok %d tdif = %.0lf, expecting %.0lf\n", $n, $tdif, $idif;

$n = 47;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt1);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = "ok";
printf "$ok %d\n", $n;

########################################################################
print "Checking leap seconds, add 3600 seconds\n";

$n = 48;
$qt2 = Qtime::add_time($qt, $SECS_PER_HOUR, 0);
$ok = (defined $qt1) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 49;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt2);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = "ok";
printf "$ok %d\n", $n;

$n = 50;
$idif = $SECS_PER_HOUR * $USECS_PER_SEC;
$tdif = Qtime::tdiff($qt2, $qt);
$ok = ($tdif == $idif) ? "ok" : "NOT ok";
printf "$ok %d tdif = %.0lf, expecting %.0lf\n", $n, $tdif, $idif;

$n = 51;
$idif = $USECS_PER_SEC;
$tdif = Qtime::tdiff($qt1,$qt2);
$ok = ($tdif == $idif) ? "ok" : "NOT ok";
printf "$ok %d tdif = %.0lf, expecting %.0lf\n", $n, $tdif, $idif;

########################################################################
print "Checking year wrap, delete 1 day\n";

$n = 52;
$qt =  Qtime::set_time("2001.001");
$qt2 = Qtime::set_time("2000.366");
$ok = (defined $qt) ? "ok" : "NOT ok";
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
Qtime::set_doy($qt,0);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt, $qt2);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
print "Checking year wrap, delete 1 day\n";

$n = 53;
$qt =  Qtime::set_time("2002.001");
$qt2 = Qtime::set_time("2001.365");
$ok = (defined $qt) ? "ok" : "NOT ok";
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
Qtime::set_doy($qt,0);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt, $qt2);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
print "Checking year wrap, delete 1 day\n";

$n = 54;
$qt =  Qtime::set_time("2000.001");
$qt2 = Qtime::set_time("1999.365");
$ok = (defined $qt) ? "ok" : "NOT ok";
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
Qtime::set_doy($qt,0);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt, $qt2);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
print "Checking year wrap, delete 1 month\n";

$n = 55;
$qt =  Qtime::set_time("2001/01/15");
$qt2 = Qtime::set_time("2000/12/15");
$ok = (defined $qt) ? "ok" : "NOT ok";
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
Qtime::set_month($qt,Qtime::month($qt)-1);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt, $qt2);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
print "Checking tepoch and nepoch time\n";

$n = 56;
$time = "2001/03/15";
$ne = 984614400;
$te = 984614422;
$qt =  Qtime::set_time($time);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf ("time = $time = $ne (nominal epoch time) = $te (true epoch time)\n");
$nepoch = Qtime::nepoch_time($qt);
printf ("nepoch_time = $nepoch\n");
$tdif = $nepoch - $ne;
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
#
$n = 57;
$tepoch = Qtime::tepoch_time($qt);
printf ("tepoch_time = $tepoch\n");
$tdif = $tepoch - $te;
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
#
$n = 58;
$qt2 = Qtime::set_time ("${tepoch}T");
$qt3 = Qtime::set_time ("${nepoch}N");
$tdif = Qtime::tdiff ($qt, $qt2);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
#
$n = 59;
$tdif = Qtime::tdiff ($qt, $qt3);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
#
$n = 60;
$tdif = Qtime::tdiff ($qt2, $qt3);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
print "Checking timespans\n";

$n = 61;
$time = "2001/03/15";
$qt =  Qtime::set_time($time);
printf ("time = $time\n");
#
$qt2 = Qtime::end_of_span ($qt,"5S");
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt2);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$qt3 = Qtime::add_dtime($qt, 5*$USECS_PER_SEC);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt3);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt2, $qt3);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
#
$n = 62;
$qt2 = Qtime::end_of_span ($qt,"10M");
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt2);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$qt3 = Qtime::add_dtime($qt, 10*60*$USECS_PER_SEC);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt3);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt2, $qt3);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
#
$n = 63;
$qt2 = Qtime::end_of_span ($qt,"3H");
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt2);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$qt3 = Qtime::add_dtime($qt, 3*3600*$USECS_PER_SEC);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt3);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt2, $qt3);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;
#
$n = 64;
$qt2 = Qtime::end_of_span ($qt,"1d");
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt2);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$qt3 = Qtime::add_dtime($qt, 86400*$USECS_PER_SEC);
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt3);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$tdif = Qtime::tdiff ($qt2, $qt3);
$ok = ($tdif == 0) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################
print "Checking settime with whitespace between date and time\n";

$n = 65;
$str = sprintf ("%04d.%03d %02d:%02d:%02d.%06d", 
	$iyear,$idoy,$ihour,$iminute,$isecond,$iusec);
$qt = Qtime::set_time($str);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 66;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 67;
$str = sprintf ("%04d.%03d  %02d:%02d:%02d.%06d", 
	$iyear,$idoy,$ihour,$iminute,$isecond,$iusec);
$qt = Qtime::set_time($str);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;


$n = 68;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 69;
$str = sprintf ("%04d/%02d/%02d\t%02d:%02d:%02d.%06d", 
	$iyear,$imonth,$iday,$ihour,$iminute,$isecond,$iusec);
$qt = Qtime::set_time($str);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 70;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 71;
$str = sprintf ("%04d/%02d/%02d  %02d:%02d:%02d.%06d", 
	$iyear,$imonth,$iday,$ihour,$iminute,$isecond,$iusec);
$qt = Qtime::set_time($str);
$ok = (defined $qt) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

$n = 72;
($oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec) = Qtime::mtime($qt);
printf ($ymdfmt,$oyear,$omonth,$oday,$ohour,$ominute,$osecond,$ousec);
$ok = ($iyear == $oyear && $imonth == $omonth && $iday == $oday && $ihour == $ohour &&
	$iminute == $ominute && $isecond == $osecond && $iusec == $ousec) ? "ok" : "NOT ok";
printf "$ok %d\n", $n;

########################################################################

print "qt = $qt\n";
print "That's all, folks!\n";

