#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "timedef.h"
#include "qtime.h"

static int Debug = 0;

static int
not_here(char *s)
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static double
constant(char *name, int arg)
{
    errno = 0;
    switch (*name) {
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

typedef struct _qtime {
	INT_TIME it;
	EXT_TIME et;
} QTIME;

MODULE = Qtime		PACKAGE = Qtime		PREFIX = qtime_

QTIME *
qtime_new (...)
    PREINIT:
	QTIME *init = NULL;
    CODE:
	QTIME *qt;
	if (Debug) printf ("Creating Qtime object, init=%s\n", (items>0) ? "yes" : "no");
	qt = calloc (1, sizeof(QTIME));
	if (items > 0) {
	    if (sv_derived_from(ST(0), "QTIMEPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		init = INT2PTR(QTIME *,tmp);
	    }
	    else
		croak("qt is not of type QTIMEPtr");
	    qt->it = init->it;
	}
	qt->et = int_to_ext(qt->it);
	RETVAL = qt;
    OUTPUT:
	RETVAL
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

QTIME *
qtime_set_time (date)
	char *date
    PREINIT:
	QTIME * qt = NULL;
	INT_TIME * pit;
    CODE:
	pit = parse_date (date);
	if (pit != NULL) {
	    if (Debug) printf ("Creating Qtime object\n");
	    qt = calloc (1, sizeof(QTIME));
	}
	else {
	    if (Debug) printf ("Error parsing date_time\n");
	}	
	if (qt) {
	    qt->it = *pit;
	    qt->et = int_to_ext(qt->it);
	}
        RETVAL = qt;
    OUTPUT:
	RETVAL	
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

QTIME *
qtime_set_itime (year, second, usec)
	int year
	int second
	int usec
    PREINIT:
	QTIME * qt = NULL;
    CODE:
	if (Debug) printf ("Creating Qtime object\n");
	qt = calloc (1, sizeof(QTIME));
	if (qt) {
	    qt->it.year = year;
	    qt->it.second = second;
	    qt->it.usec = usec;
	    qt->it = normalize_time(qt->it);
	    qt->et = int_to_ext(qt->it);
	}
	RETVAL = qt;
    OUTPUT:
	RETVAL	
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

int
qtime_itime (qt)
	QTIME * qt
    PPCODE:
	EXTEND (SP, 3);
	PUSHs (sv_2mortal(newSViv(qt->it.year)));
	PUSHs (sv_2mortal(newSViv(qt->it.second)));
	PUSHs (sv_2mortal(newSViv(qt->it.usec)));

QTIME *
qtime_set_jtime (year, doy, hour, minute, second, usec)
	int year
	int doy
	int hour
	int minute
	int second
	int usec
    PREINIT:
	QTIME * qt = NULL;
    CODE:
	if (Debug) printf ("Creating Qtime object\n");
	qt = calloc (1, sizeof(QTIME));
	if (qt) {
	    qt->et.year = year;
	    qt->et.doy = doy;
	    dy_to_mdy (doy, year, &qt->et.month, &qt->et.day);
	    qt->et.hour = hour;
	    qt->et.minute = minute;
	    qt->et.second = second;
	    qt->et.usec = usec;
	    qt->et = normalize_ext (qt->et);
	    qt->it = ext_to_int (qt->et);
	}
	RETVAL = qt;
    OUTPUT:
	RETVAL
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

int
qtime_jtime (qt)
	QTIME * qt
    PPCODE:
	EXTEND(SP, 6);
	PUSHs (sv_2mortal(newSViv(qt->et.year)));
	PUSHs (sv_2mortal(newSViv(qt->et.doy)));
	PUSHs (sv_2mortal(newSViv(qt->et.hour)));
	PUSHs (sv_2mortal(newSViv(qt->et.minute)));
	PUSHs (sv_2mortal(newSViv(qt->et.second)));
	PUSHs (sv_2mortal(newSViv(qt->et.usec)));

QTIME *
qtime_set_mtime (year, month, day, hour, minute, second, usec)
	int year
	int month
	int day
	int hour
	int minute
	int second
	int usec
    PREINIT:
	QTIME * qt = NULL;
    CODE:
	if (Debug) printf ("Creating Qtime object\n");
	qt = calloc (1, sizeof(QTIME));
	if (qt) {
	    qt->et.year = year;
	    qt->et.month = month;
	    qt->et.day = day;
	    qt->et.doy = mdy_to_doy(qt->et.month, qt->et.day, qt->et.year);
	    qt->et.hour = hour;
	    qt->et.minute = minute;
	    qt->et.second = second;
	    qt->et.usec = usec;
	    qt->et = normalize_ext (qt->et);
	    qt->it = ext_to_int (qt->et);
	}
	RETVAL = qt;
    OUTPUT:
	RETVAL
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

void
qtime_mtime (qt)
	QTIME * qt
    PPCODE:
	EXTEND(SP, 7);
	PUSHs (sv_2mortal(newSViv(qt->et.year)));
	PUSHs (sv_2mortal(newSViv(qt->et.month)));
	PUSHs (sv_2mortal(newSViv(qt->et.day)));
	PUSHs (sv_2mortal(newSViv(qt->et.hour)));
	PUSHs (sv_2mortal(newSViv(qt->et.minute)));
	PUSHs (sv_2mortal(newSViv(qt->et.second)));
	PUSHs (sv_2mortal(newSViv(qt->et.usec)));

QTIME *
qtime_set_doytime (year, doy, doysecond, usec)
	int year
	int doy
	int doysecond
	int usec
    PREINIT:
	QTIME * qt = NULL;
    CODE:
	if (Debug) printf ("Creating Qtime object\n");
	qt = calloc (1, sizeof(QTIME));
	if (qt) {
	    qt->et.year = year;
	    qt->et.doy = doy;
	    dy_to_mdy (doy, year, &qt->et.month, &qt->et.day);
	    qt->et = normalize_ext (qt->et);
	    qt->it = ext_to_int (qt->et);
	    qt->it.second += doysecond;
	    qt->it.usec += usec;
	    qt->it = normalize_time(qt->it);
	    qt->et = int_to_ext(qt->it);
	}
	RETVAL = qt;
    OUTPUT:
	RETVAL
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

int
qtime_doytime (qt)
	QTIME * qt
    PPCODE:
	EXTEND(SP, 4);
	PUSHs (sv_2mortal(newSViv(qt->et.year)));
	PUSHs (sv_2mortal(newSViv(qt->et.doy)));
	PUSHs (sv_2mortal(newSViv(qt->et.hour*3600 + qt->et.minute*60 + qt->et.second)));
	PUSHs (sv_2mortal(newSViv(qt->et.usec)));

int 
qtime_set_year (qt, year)
	QTIME * qt
	int year
    CODE:
	qt->it.year = year;
	qt->it = normalize_time (qt->it);
	qt->et = int_to_ext (qt->it);
	RETVAL = year;
    OUTPUT:
	RETVAL

int 
qtime_year (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->it.year;
    OUTPUT:
	RETVAL

int 
qtime_set_isecond (qt, second)
	QTIME * qt
	int second
    CODE:
	qt->it.second = second;
	qt->it = normalize_time (qt->it);
	qt->et = int_to_ext (qt->it);
	RETVAL = second;
    OUTPUT:
	RETVAL

int 
qtime_isecond (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->it.second;
    OUTPUT:
	RETVAL

int 
qtime_set_usec (qt, usec)
	QTIME * qt
	int usec
    CODE:
	qt->it.usec = usec;
	qt->it = normalize_time (qt->it);
	qt->et = int_to_ext (qt->it);
	RETVAL = usec;
    OUTPUT:
	RETVAL

int 
qtime_usec (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->it.usec;
    OUTPUT:
	RETVAL

int 
qtime_set_month (qt, month)
	QTIME * qt
	int month
    CODE:
	qt->et.month = month;
	while (qt->et.month > 12) {
	    qt->et.month -= 12;
	    ++(qt->et.year);
	}
	while (qt->et.month <= 0) {
	    qt->et.month += 12;
	    --(qt->et.year);
	}
	qt->et.doy = mdy_to_doy (qt->et.month, qt->et.day, qt->et.year);
	qt->et = normalize_ext (qt->et);
	qt->it = ext_to_int (qt->et);
	RETVAL = month;
    OUTPUT:
	RETVAL

int 
qtime_month (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->et.month;
    OUTPUT:
	RETVAL

int 
qtime_set_day (qt, day)
	QTIME * qt
	int day
    CODE:
	qt->et.day = day;
	qt->et.doy = mdy_to_doy (qt->et.month, qt->et.day, qt->et.year);
	qt->et = normalize_ext (qt->et);
	qt->it = ext_to_int (qt->et);
	RETVAL = day;
    OUTPUT:
	RETVAL

int 
qtime_day (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->et.day;
    OUTPUT:
	RETVAL

int 
qtime_set_doy (qt, doy)
	QTIME * qt
	int doy
    CODE:
	qt->et.doy = doy;
	dy_to_mdy (qt->et.doy, qt->et.year, &qt->et.month, &qt->et.day);
	qt->et = normalize_ext (qt->et);
	qt->it = ext_to_int (qt->et);
	RETVAL = doy;
    OUTPUT:
	RETVAL

int 
qtime_doy (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->et.doy;
    OUTPUT:
	RETVAL

int 
qtime_set_hour (qt, hour)
	QTIME * qt
	int hour
    CODE:
	qt->et.hour = hour;
	qt->et = normalize_ext (qt->et);
	qt->it = ext_to_int (qt->et);
	RETVAL = hour;
    OUTPUT:
	RETVAL

int 
qtime_hour (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->et.hour;
    OUTPUT:
	RETVAL

int 
qtime_set_minute (qt, minute)
	QTIME * qt
	int minute
    CODE:
	qt->et.minute = minute;
	qt->et = normalize_ext (qt->et);
	qt->it = ext_to_int (qt->et);
	RETVAL = minute;
    OUTPUT:
	RETVAL

int 
qtime_minute (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->et.minute;
    OUTPUT:
	RETVAL

int 
qtime_set_second (qt, second)
	QTIME * qt
	int second
    CODE:
	qt->et.second = second;
	qt->et = normalize_ext (qt->et);
	qt->it = ext_to_int (qt->et);
	RETVAL = second;
    OUTPUT:
	RETVAL

int 
qtime_second (qt)
	QTIME * qt
    CODE:
	RETVAL = qt->et.second;
    OUTPUT:
	RETVAL

double 
qtime_tdiff (qt1, qt2)
	QTIME * qt1
	QTIME * qt2
    CODE:
	RETVAL = tdiff(qt1->it, qt2->it);
    OUTPUT:
	RETVAL

QTIME *
qtime_add_dtime (qt, usec)
	QTIME * qt
	double	usec
    PREINIT:
	QTIME * new = NULL;
    CODE:
	if (Debug) printf ("Creating Qtime object\n");
	new = calloc (1, sizeof(QTIME));
	if (new) {
	    new->it = add_dtime(qt->it, usec);
	    new->et = int_to_ext(new->it);
	}
	RETVAL = new;
    OUTPUT:
	RETVAL
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

QTIME *
qtime_add_time (qt, second, usec)
	QTIME * qt
	int	second
	int	usec
    PREINIT:
	QTIME * new = NULL;
    CODE:
	if (Debug) printf ("Creating Qtime object\n");
	new = calloc (1, sizeof(QTIME));
	if (new) {
	    new->it = add_time(qt->it, second, usec);
	    new->et = int_to_ext(new->it);
	}
	RETVAL = new;
    OUTPUT:
	RETVAL
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

double 
qtime_tepoch_time (qt)
	QTIME * qt
    CODE:
	RETVAL = int_to_tepoch(qt->it);
    OUTPUT:
	RETVAL

double 
qtime_nepoch_time (qt)
	QTIME * qt
    CODE:
	RETVAL = int_to_nepoch(qt->it);
    OUTPUT:
	RETVAL

QTIME *
qtime_end_of_span (qt, span)
	QTIME * qt
	char  *	span
    PREINIT:
	QTIME * new = NULL;
    CODE:
	if (Debug) printf ("Creating Qtime object\n");
	new = calloc (1, sizeof(QTIME));
	if (new) {
	    new->it = end_of_span(qt->it, span);
	    new->et = int_to_ext(new->it);
	}
	RETVAL = new;
    OUTPUT:
	RETVAL
    CLEANUP:
	if (RETVAL == NULL) XSRETURN_UNDEF;

MODULE = Qtime		PACKAGE = QTIMEPtr	PREFIX = qtime_

void
qtime_DESTROY (qt)
	QTIME * qt
    CODE:
	if (Debug) printf ("Now in Qtime::DESTROY\n");
	free (qt);
