package Qtime;

require 5.005_62;
use strict;
use warnings;
use Carp;

require Exporter;
require DynaLoader;
use AutoLoader;

our $SECS_PER_MINUTE	= 60;
our $SECS_PER_HOUR	= 3600;
our $SECS_PER_DAY	= 86400;
our $TICKS_PER_SEC	= 10000;
our $TICKS_PER_MSEC	= ($TICKS_PER_SEC/1000);
our $USECS_PER_SEC	= 1000000;
our $USECS_PER_MSEC	= ($USECS_PER_SEC/1000);
our $USECS_PER_TICK	= ($USECS_PER_SEC/$TICKS_PER_SEC);

our @ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Qtime ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
set_time set_itime itime set_jtime jtime set_mtime mtime 
set_year year set_isecond isecond set_usec usec
set_month month set_day day set_doy doy 
set_hour hour set_minute minute set_second second
tepoch_time nepoch_time end_of_span
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
$SECS_PER_MINUTE $SECS_PER_HOUR $SECS_PER_DAY
$TICKS_PER_SEC $TICKS_PER_MSEC 
$USECS_PER_SEC $USECS_PER_MSEC $USECS_PER_TICK
);
our $VERSION = '0.09';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/ || $!{EINVAL}) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
	    croak "Your vendor has not defined Qtime macro $constname";
	}
    }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
	if ($] >= 5.00561) {
	    *$AUTOLOAD = sub () { $val };
	}
	else {
	    *$AUTOLOAD = sub { $val };
	}
    }
    goto &$AUTOLOAD;
}

bootstrap Qtime $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

Qtime - Perl extension for qlib2 time functions.

=head1 SYNOPSIS

  use Qtime;
  use Qtime ':all';

  qt = Qtime::new();
  qt2 = Qtime::new($qt1);

  $qt = Qtime::set_time("2001/01/23,12:34:56.789");
  $qt = Qtime::set_time("2001.023,12:34:56.789");

  $qt = Qtime::set_itime(2001,123456,789000);
  ($year,$second,$usec) = Qtime::itime($qt);

  $qt = Qtime::set_jtime (2001,23,12,34,56,789000);
  ($year,$doy,$hour,$minute,$second,$usec) = Qtime::jtime($qt);

  $qt = Qtime::set_mtime (2001,1,23,12,34,56,789000);
  ($year,$month,$day,$hour,$minute,$second,$usec) = Qtime::mtime($qt);

  $qt = Qtime::set_doytime (2001,23,45296,789000);
  ($year,$doy,$secondsinday,$usecs) = Qtime::doytime($qt);

  $year = Qtime::set_year($qt,2002);
  $year = Qtime::year($qt);

  $month = Qtime::set_month($qt,01);
  $month = Qtime::month($qt);

  $day = Qtime::set_day($qt,23);
  $day = Qtime::day($qt);

  $doy = Qtime::set_doy($qt,253);
  $doy = Qtime::doy($qt);

  $hour = Qtime::set_hour($qt,253);
  $hour = Qtime::hour($qt);

  $minute = Qtime::set_minute($qt,253);
  $minute = Qtime::minute($qt);

  $second = Qtime::set_second($qt,253);
  $second = Qtime::second($qt);

  $usec = Qtime::set_usec($qt,789000);
  $usec = Qtime::usec($qt);

  $isecond = Qtime::set_isecond($qt,123456);
  $isecond = Qtime::isecond($qt);

  $usecs = Qtime::tdiff($qt1,$qt2);

  $qt2 = Qtime::add_dtime ($qt1,$usecs);

  $qt2 = Qtime::add_time ($qt1,$seconds,$usecs);

  $tepoch = Qtime::tepoch_time ($qt1);

  $nepoch = Qtime::nepoch_time ($qt1);

  $qt2 = Qtime::end_of_span ($qt1,$timespan);

  $SECS_PER_MINUTE	= 60;
  $SECS_PER_HOUR	= 3600;
  $SECS_PER_DAY		= 86400;
  $TICKS_PER_SEC	= 10000;
  $TICKS_PER_MSEC	= ($TICKS_PER_SEC/1000);
  $USECS_PER_SEC	= 1000000;
  $USECS_PER_MSEC	= ($USECS_PER_SEC/1000);
  $USECS_PER_TICK	= ($USECS_PER_SEC/$TICKS_PER_SEC);

=head1 DESCRIPTION

Qtime is a perl module that provides some of the qlib2 time functions.

You must first create a Qtime object with the Qtime::new() function
or the Qtime::set_time() function.
You may then use the other Qtime functions to set and retrieve time
using one of the  qlib2 time representations:

  year,isecond,usec
  year,month,day,hour,minute,second,usec
  year,doy,hour,minute,second,usec
  
where isecond is the second offset from the year, usec is microseconds,
and doy is the day of year.

The Qtime::tepoch_time() and Qtime::nepoch_time() return a double
precision value representing the true epoch time (including leapseconds)
and nominal epoch time (not including leapsecond).
Epoch times are the number of seconds since Jan 1, 1970.

The Qtime::end_of_span() function will compute the end of a timespan
starting at the specified qtime with a duration of the interval.
Interval can be an integer followed immediately by
S, M, H, d, m, y, or Y for seconds, minutes, hours, days, months,
or years. If no character is specifyed, seconds are assumed.

All other variables are self-explanatory.

=head2 EXPORT

The named constants 

  $SECS_PER_MINUTE,
  $SECS_PER_HOUR,
  $SECS_PER_DAY,
  $TICKS_PER_SEC,
  $TICKS_PER_MSEC,
  $USECS_PER_SEC,
  $USECS_PER_MSEC,
  $USECS_PER_TICK,

are imported by default.

No functions are imported by default. However, if you may use:

  use Qtime ':all :DEFAULT';

to import all functions as well as all named constants.

=head1 AUTHOR

Doug Neuhauser, UC Berkeley Seismological Laboratory, doug@seismo.berkeley.edu

=head1 SEE ALSO

qlib2(3), perl(1).

=cut
