
VARIANT=""
###VARIANT="_withARC_S"  # with ARC S

HYP_FILE="out/20240806/Hemstock_MEN2/loc_nll_20240805_picks${VARIANT}/MendocinoHistorical_2022.19541221.195631.grid0.loc.hyp out/20240826/Hemstock_MEN2/loc_nll_20240805_picks${VARIANT}_z*/MendocinoHistorical_2022.sum.grid0.loc.hyp"
NAME="1954"
#
###HYP_FILE="out/20250307/Dreger_GIL7/loc_nll_20240805_picks${VARIANT}/MendocinoHistorical_2022.19541221.195631.grid0.loc.hyp out/20250307/Dreger_GIL7/loc_nll_20240805_picks${VARIANT}_z*/MendocinoHistorical_2022.sum.grid0.loc.hyp"
###NAME="1954_GIL7"


###VARIANT="_withARC_S_ARC_EUR_FER"
###HYP_FILE="out/20250317/Hemstock_MEN2/loc_nll_20240805_picks_withARC_S_ARC_EUR_FER/MendocinoHistorical_2022.19541221.195631.grid0.loc.hyp"
###NAME="1954"


TITLE="NLL ${NAME}${VARIANT}"

IMAGE2D="image2d=maps/MendocinoHistorical1954_opentopography.png; 40.5,-124.75; 41.3,-123.5; 0.0"

SNAPSHOT_NAME="${TITLE//" "/_}"


#FILTER_OTIME="-event.filter.otime 2021,12,20,20,10,00"	
		#COLORMAP="-event.colormap=OTIME;2010,01,01,00,00,00,191,215,215,191;2021,12,20,20,10,00,105,127,127,191;2021,12,20,20,10,00,225,127,0,223;2022,12,20,00,00,00,225,127,0,223;2022,12,20,00,00,00,95,64,255,223;2023,12,31,00,00,00,95,64,255,223"
#COLORMAP="-event.colormap=OTIME;2022,12,20,00,00,00,215,215,215,223;2022,12,20,00,00,00,95,64,255,223;2023,01,20,00,00,00,95,64,255,223;2023,01,20,00,00,00,91,91,127,127;2023,03,20,00,00,00,91,91,127,127"
#COLORMAP="-event.colormap=OTIME"

FILETYPE="-event.filtype NLLOC"

TITLE_XY="-13 -8 3"

#FILTER_DEPTH="-event.filter.depth -99,99"
#FILTER_SE3="-event.filter.ellipsoid.se3 -1,10"
#FILTER_MAG="-event.filter.mag=-99,99"
#REVERSE="-event.display.reverse=NO"
#EXPECTATION="-show.expectation=YES -show.maxlikelihood=NO"
#RANDOMIZE=-event.randomize=0.05

SYMBOLS="-symbols.0=maps/20240806_Hemstock_MEN2_loc_nll_20240805_picks.xyz;CROSS;0,0,0;7.0;1.0;1954_NLL"

	
# ======================
# General settings

FILTERS="${FILTER_DEPTH} ${FILTER_SE3} ${FILTER_MAG} ${FILTER_OTIME}"
SV_MISC="${FILETYPE} ${SYMBOLS} ${COLORMAP} ${REVERSE} ${EXPECTATION} ${RANDOMIZE} ${FILTERS} -event.colormap DEPTH  -event.size 4 -scattersamples.applycolormap=NO -scattersamples=191,16,16#4#2 -paint.events.last=NO -event.filter.depth 0,30 -show.ellipsoid=NO -grid.zlimits.spaced=NONE -grid.latlon.depth=0.0,50.0 -station.symbol.size=4.5"

cp maps/map.text maps/temp.text
cat >> maps/temp.text << END
#"${TITLE}" 1 0 XYZ   ${TITLE_XYZ}   1.0 0.0 0.0   0.0 1.0  0.0   0 0 0   2.5   PLAIN  Sans
END
SV_MISC_MAP="${SV_MISC} ${POLYGONS} ${IMAGE2D} -text=maps/temp.text -grid.azscale.pos="

SNAPSHOT_DIR=figures
mkdir -p ${SNAPSHOT_DIR}
SNAPSHOT_BASE="-snapshot.format=png -snapshot.directory=${SNAPSHOT_DIR}"
SNAPSHOT="${SNAPSHOT_BASE} -snapshot.autoexit=YES"
VIEW_BASE="-text.sizefactor=2.5"


# ======================
# Map with section
SNAPSHOT_SIZE="-snapshot.size=2000,2000"
VIEW=" ${VIEW_BASE} -init.zoom=-1 -init.viewpoint=180,90 -grid.latlon.clip=YES "
##
java -jar SeismicityViewer50.jar  -grid.zlimits.spaced=NONE ${HYP_FILE} ${SV_MISC_MAP} ${VIEW} ${SNAPSHOT} ${SNAPSHOT_SIZE} ; cp ${SNAPSHOT_DIR}/snapshot.0000.png ${SNAPSHOT_DIR}/temp_map.png

#cp maps/map.text maps/temp.text
cat > maps/temp.text << END
"${TITLE}" 1 0 XYZ   ${TITLE_XYZ}   1.0 0.0 0.0   0.0 0.0  1.0   0 0 0   2.5   PLAIN  Sans
END
SV_MISC_SECT="${SV_MISC} ${POLYGONS} -show.grid.latlon=YES -show.grid=NO -text=maps/temp.text -show.stationsymbol=NO -show.station=NO"
VIEW_BASE_SECT="${VIEW_BASE}  -init.zoom=-1 -lines.0= -shapefiles.0="

# ======================
# Section view South
SNAPSHOT_SIZE="-snapshot.size=2000,1200"
VIEW=" ${VIEW_BASE_SECT} -init.viewpoint=180,0 -grid.zlimits.spaced=SE -grid.azscale.pos=0.15,0.000,0.90,1.5,3.0,90"
##
java -jar SeismicityViewer50.jar  -grid.zlimits.spaced=SE ${HYP_FILE} ${SV_MISC_SECT} ${VIEW} ${SNAPSHOT} ${SNAPSHOT_SIZE} ; cp ${SNAPSHOT_DIR}/snapshot.0000.png ${SNAPSHOT_DIR}/temp_south.png

convert ${SNAPSHOT_DIR}/temp_map.png -crop 2000x2700+0+100 ${SNAPSHOT_DIR}/temp_map2.png
convert ${SNAPSHOT_DIR}/temp_south.png -crop 2000x1150+0+100 ${SNAPSHOT_DIR}/temp_south2.png
convert ${SNAPSHOT_DIR}/temp_map2.png ${SNAPSHOT_DIR}/temp_south2.png -smush -345 ${SNAPSHOT_DIR}/temp.png

# ======================
# Section view East
SNAPSHOT_SIZE="-snapshot.size=2000,1200"
VIEW=" ${VIEW_BASE_SECT} -init.viewpoint=90,0 -grid.zlimits.spaced=NE -grid.azscale.pos=0.00,0.3,0.90,1.5,3.0,0"
##
java -jar SeismicityViewer50.jar ${HYP_FILE} ${SV_MISC_SECT} ${VIEW} ${SNAPSHOT} ${SNAPSHOT_SIZE} ; cp ${SNAPSHOT_DIR}/snapshot.0000.png ${SNAPSHOT_DIR}/temp_east.png

#convert ${SNAPSHOT_DIR}/temp_east.png -crop 2300x975+451+120 -rotate -90 ${SNAPSHOT_DIR}/temp_east2.png
convert ${SNAPSHOT_DIR}/temp_east.png -crop 1650x900+250+120 -rotate -90 ${SNAPSHOT_DIR}/temp_east2.png
convert ${SNAPSHOT_DIR}/temp.png ${SNAPSHOT_DIR}/temp_east2.png -background "rgb(255,255,255)" +smush -200 ${SNAPSHOT_DIR}/temp2.png
#convert ${SNAPSHOT_DIR}/temp2.png -crop +160 ${SNAPSHOT_DIR}/${SNAPSHOT_NAME}.png
mv ${SNAPSHOT_DIR}/temp2.png ${SNAPSHOT_DIR}/${SNAPSHOT_NAME}.png

##rm figures/temp*

open -a Preview ${SNAPSHOT_DIR}/${SNAPSHOT_NAME}.png
	
