/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

public final class MathUtils {
    private static final byte NB = -1;
    private static final short NS = -1;
    private static final byte PB = 1;
    private static final short PS = 1;
    private static final byte ZB = 0;
    private static final short ZS = 0;

    private MathUtils() {
    }

    public static int addAndCheck(int n, int n2) {
        long l = (long)n + (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l;
    }

    public static long binomialCoefficient(int n, int n2) {
        if (n < n2) {
            throw new IllegalArgumentException("must have n >= k for binomial coefficient (n,k)");
        }
        if (n < 0) {
            throw new IllegalArgumentException("must have n >= 0 for binomial coefficient (n,k)");
        }
        if (n == n2 || n2 == 0) {
            return 1L;
        }
        if (n2 == 1 || n2 == n - 1) {
            return n;
        }
        long l = Math.round(MathUtils.binomialCoefficientDouble(n, n2));
        if (l == Long.MAX_VALUE) {
            throw new ArithmeticException("result too large to represent in a long integer");
        }
        return l;
    }

    public static double binomialCoefficientDouble(int n, int n2) {
        return Math.floor(Math.exp(MathUtils.binomialCoefficientLog(n, n2)) + 0.5);
    }

    public static double binomialCoefficientLog(int n, int n2) {
        int n3;
        if (n < n2) {
            throw new IllegalArgumentException("must have n >= k for binomial coefficient (n,k)");
        }
        if (n < 0) {
            throw new IllegalArgumentException("must have n >= 0 for binomial coefficient (n,k)");
        }
        if (n == n2 || n2 == 0) {
            return 0.0;
        }
        if (n2 == 1 || n2 == n - 1) {
            return Math.log(n);
        }
        double d = 0.0;
        for (n3 = n2 + 1; n3 <= n; ++n3) {
            d += Math.log(n3);
        }
        for (n3 = 2; n3 <= n - n2; ++n3) {
            d -= Math.log(n3);
        }
        return d;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static boolean equals(double d, double d2) {
        return Double.isNaN(d) && Double.isNaN(d2) || d == d2;
    }

    public static long factorial(int n) {
        long l = Math.round(MathUtils.factorialDouble(n));
        if (l == Long.MAX_VALUE) {
            throw new ArithmeticException("result too large to represent in a long integer");
        }
        return l;
    }

    public static double factorialDouble(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("must have n >= 0 for n!");
        }
        return Math.floor(Math.exp(MathUtils.factorialLog(n)) + 0.5);
    }

    public static double factorialLog(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("must have n > 0 for n!");
        }
        double d = 0.0;
        for (int i = 2; i <= n; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    public static int gcd(int n, int n2) {
        int n3;
        int n4;
        if (n * n2 == 0) {
            return Math.abs(n) + Math.abs(n2);
        }
        if (n > 0) {
            n = -n;
        }
        if (n2 > 0) {
            n2 = -n2;
        }
        for (n4 = 0; (n & 1) == 0 && (n2 & 1) == 0 && n4 < 31; ++n4) {
            n /= 2;
            n2 /= 2;
        }
        if (n4 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int n5 = n3 = (n & 1) == 1 ? n2 : -(n / 2);
        while (true) {
            if ((n3 & 1) == 0) {
                n3 /= 2;
                continue;
            }
            if (n3 > 0) {
                n = -n3;
            } else {
                n2 = n3;
            }
            if ((n3 = (n2 - n) / 2) == 0) break;
        }
        return -n * (1 << n4);
    }

    public static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public static byte indicator(byte by) {
        return by >= 0 ? (byte)1 : -1;
    }

    public static double indicator(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return d >= 0.0 ? 1.0 : -1.0;
    }

    public static float indicator(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        return f >= 0.0f ? 1.0f : -1.0f;
    }

    public static int indicator(int n) {
        return n >= 0 ? 1 : -1;
    }

    public static long indicator(long l) {
        return l >= 0L ? 1L : -1L;
    }

    public static short indicator(short s) {
        return s >= 0 ? (short)1 : -1;
    }

    public static int lcm(int n, int n2) {
        return Math.abs(MathUtils.mulAndCheck(n / MathUtils.gcd(n, n2), n2));
    }

    public static int mulAndCheck(int n, int n2) {
        long l = (long)n * (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)l;
    }

    public static double round(double d, int n) {
        return MathUtils.round(d, n, 4);
    }

    public static double round(double d, int n, int n2) {
        double d2 = MathUtils.indicator(d);
        double d3 = Math.pow(10.0, n) * d2;
        return MathUtils.roundUnscaled(d * d3, d2, n2) / d3;
    }

    public static float round(float f, int n) {
        return MathUtils.round(f, n, 4);
    }

    public static float round(float f, int n, int n2) {
        float f2 = MathUtils.indicator(f);
        float f3 = (float)Math.pow(10.0, n) * f2;
        return (float)MathUtils.roundUnscaled(f * f3, f2, n2) / f3;
    }

    private static double roundUnscaled(double d, double d2, int n) {
        switch (n) {
            case 2: {
                if (d2 == -1.0) {
                    d = Math.floor(d);
                    break;
                }
                d = Math.ceil(d);
                break;
            }
            case 1: {
                d = Math.floor(d);
                break;
            }
            case 3: {
                if (d2 == -1.0) {
                    d = Math.ceil(d);
                    break;
                }
                d = Math.floor(d);
                break;
            }
            case 5: {
                double d3 = Math.abs(d - Math.floor(d));
                if (d3 > 0.5) {
                    d = Math.ceil(d);
                    break;
                }
                d = Math.floor(d);
                break;
            }
            case 6: {
                double d4 = Math.abs(d - Math.floor(d));
                if (d4 > 0.5) {
                    d = Math.ceil(d);
                    break;
                }
                if (d4 < 0.5) {
                    d = Math.floor(d);
                    break;
                }
                if (Math.floor(d) / 2.0 == Math.floor(Math.floor(d) / 2.0)) {
                    d = Math.floor(d);
                    break;
                }
                d = Math.ceil(d);
                break;
            }
            case 4: {
                double d5 = Math.abs(d - Math.floor(d));
                if (d5 >= 0.5) {
                    d = Math.ceil(d);
                    break;
                }
                d = Math.floor(d);
                break;
            }
            case 7: {
                if (d == Math.floor(d)) break;
                throw new ArithmeticException("Inexact result from rounding");
            }
            case 0: {
                d = Math.ceil(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rounding method.");
            }
        }
        return d;
    }

    public static byte sign(byte by) {
        return (byte)(by == 0 ? 0 : (by > 0 ? 1 : -1));
    }

    public static double sign(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return d == 0.0 ? 0.0 : (d > 0.0 ? 1.0 : -1.0);
    }

    public static float sign(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        return f == 0.0f ? 0.0f : (f > 0.0f ? 1.0f : -1.0f);
    }

    public static int sign(int n) {
        return n == 0 ? 0 : (n > 0 ? 1 : -1);
    }

    public static long sign(long l) {
        return l == 0L ? 0L : (l > 0L ? 1L : -1L);
    }

    public static short sign(short s) {
        return (short)(s == 0 ? 0 : (s > 0 ? 1 : -1));
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static int subAndCheck(int n, int n2) {
        long l = (long)n - (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: subtract");
        }
        return (int)l;
    }
}

