/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class SumOfSquares
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 1460986908574398008L;
    private long n = 0L;
    private double value = Double.NaN;

    @Override
    public void increment(double d) {
        this.value = this.n == 0L ? d * d : (this.value += d * d);
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += dArray[i] * dArray[i];
            }
        }
        return d;
    }
}

