/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;

public class ThirdMoment
extends SecondMoment
implements Serializable {
    private static final long serialVersionUID = -7818711964045118679L;
    protected double m3 = Double.NaN;
    protected double nDevSq = Double.NaN;

    @Override
    public void increment(double d) {
        if (this.n < 1L) {
            this.m1 = 0.0;
            this.m2 = 0.0;
            this.m3 = 0.0;
        }
        double d2 = this.m2;
        super.increment(d);
        this.nDevSq = this.nDev * this.nDev;
        double d3 = this.n;
        this.m3 = this.m3 - 3.0 * this.nDev * d2 + (d3 - 1.0) * (d3 - 2.0) * this.nDevSq * this.dev;
    }

    @Override
    public double getResult() {
        return this.m3;
    }

    @Override
    public void clear() {
        super.clear();
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }
}

