/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.classes;

import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassDiscover;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.ResourceDiscoverImpl;

public abstract class ResourceClassDiscoverImpl
extends ResourceDiscoverImpl
implements ResourceClassDiscover {
    public ResourceClassDiscoverImpl() {
    }

    public ResourceClassDiscoverImpl(ClassLoaders classLoaders) {
        super(classLoaders);
    }

    @Override
    public ResourceNameIterator findResourceNames(String string) {
        return this.findResourceClasses(string);
    }

    @Override
    public ResourceNameIterator findResourceNames(ResourceNameIterator resourceNameIterator) {
        return this.findResourceClasses(resourceNameIterator);
    }

    @Override
    public ResourceIterator findResources(String string) {
        return this.findResourceClasses(string);
    }

    @Override
    public ResourceIterator findResources(ResourceNameIterator resourceNameIterator) {
        return this.findResourceClasses(resourceNameIterator);
    }

    @Override
    public abstract ResourceClassIterator findResourceClasses(String var1);

    @Override
    public ResourceClassIterator findResourceClasses(final ResourceNameIterator resourceNameIterator) {
        return new ResourceClassIterator(){
            private ResourceClassIterator classes = null;
            private ResourceClass resource = null;

            @Override
            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextResource();
                }
                return this.resource != null;
            }

            @Override
            public ResourceClass nextResourceClass() {
                ResourceClass resourceClass = this.resource;
                this.resource = null;
                return resourceClass;
            }

            private ResourceClass getNextResource() {
                while (resourceNameIterator.hasNext() && (this.classes == null || !this.classes.hasNext())) {
                    this.classes = ResourceClassDiscoverImpl.this.findResourceClasses(resourceNameIterator.nextResourceName());
                }
                return this.classes != null && this.classes.hasNext() ? this.classes.nextResourceClass() : null;
            }
        };
    }
}

