/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.classes;

import java.net.URL;
import java.util.Vector;
import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassDiscover;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.ResourceClassDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverClasses
extends ResourceClassDiscoverImpl
implements ResourceClassDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverClasses.class);

    public static void setLog(Log log) {
        DiscoverClasses.log = log;
    }

    public DiscoverClasses() {
    }

    public DiscoverClasses(ClassLoaders classLoaders) {
        super(classLoaders);
    }

    @Override
    public ResourceClassIterator findResourceClasses(final String string) {
        final String string2 = string.replace('.', '/') + ".class";
        if (log.isDebugEnabled()) {
            log.debug("find: className='" + string + "'");
        }
        return new ResourceClassIterator(){
            private Vector history = new Vector();
            private int idx = 0;
            private ResourceClass resource = null;

            @Override
            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextClass();
                }
                return this.resource != null;
            }

            @Override
            public ResourceClass nextResourceClass() {
                ResourceClass resourceClass = this.resource;
                this.resource = null;
                return resourceClass;
            }

            private ResourceClass getNextClass() {
                while (this.idx < DiscoverClasses.this.getClassLoaders().size()) {
                    ClassLoader classLoader = DiscoverClasses.this.getClassLoaders().get(this.idx++);
                    URL uRL = classLoader.getResource(string2);
                    if (uRL != null) {
                        if (!this.history.contains(uRL)) {
                            this.history.addElement(uRL);
                            if (log.isDebugEnabled()) {
                                log.debug("getNextClass: next URL='" + uRL + "'");
                            }
                            return new ResourceClass(string, uRL, classLoader);
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("getNextClass: duplicate URL='" + uRL + "'");
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("getNextClass: loader " + classLoader + ": '" + string2 + "' not found");
                }
                return null;
            }
        };
    }
}

