/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource;

import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceDiscover;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;

public abstract class ResourceDiscoverImpl
extends ResourceNameDiscoverImpl
implements ResourceDiscover {
    private ClassLoaders classLoaders;

    public ResourceDiscoverImpl() {
    }

    public ResourceDiscoverImpl(ClassLoaders classLoaders) {
        this.setClassLoaders(classLoaders);
    }

    public void setClassLoaders(ClassLoaders classLoaders) {
        this.classLoaders = classLoaders;
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.getClassLoaders().put(classLoader);
    }

    protected ClassLoaders getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = ClassLoaders.getLibLoaders(this.getClass(), null, true);
        }
        return this.classLoaders;
    }

    @Override
    public ResourceNameIterator findResourceNames(String string) {
        return this.findResources(string);
    }

    @Override
    public ResourceNameIterator findResourceNames(ResourceNameIterator resourceNameIterator) {
        return this.findResources(resourceNameIterator);
    }

    @Override
    public abstract ResourceIterator findResources(String var1);

    @Override
    public ResourceIterator findResources(final ResourceNameIterator resourceNameIterator) {
        return new ResourceIterator(){
            private ResourceIterator resources = null;
            private Resource resource = null;

            @Override
            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextResource();
                }
                return this.resource != null;
            }

            @Override
            public Resource nextResource() {
                Resource resource = this.resource;
                this.resource = null;
                return resource;
            }

            private Resource getNextResource() {
                while (resourceNameIterator.hasNext() && (this.resources == null || !this.resources.hasNext())) {
                    this.resources = ResourceDiscoverImpl.this.findResources(resourceNameIterator.nextResourceName());
                }
                return this.resources != null && this.resources.hasNext() ? this.resources.nextResource() : null;
            }
        };
    }
}

