/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing.seis;

import java.net.URL;
import java.util.Date;
import net.alomax.net.CgiBinParameterSet;
import net.alomax.net.CgiBinRequest;
import net.alomax.swing.seis.EventSearchException;
import net.alomax.swing.seis.SeisText;

public class EventSearchParameters {
    public static final String[] searchTypeName = new String[]{"SEARCH_NEIC_PDE", "SEARCH_NEIC_PDEQ", "SEARCH_NEIC_SWE"};
    public static final String[] searchDescription = new String[]{"USGS/NEIC (PDE) 1973 - Present", "USGS/NEIC (PDE-Q) Most Recent Events", "NEIC Significant Worldwide Earthquakes (2150 B.C. - 1994 A.D.)"};
    public static final String[] searchCredits = new String[]{"USGS National Earthquake Information Center: http://neic.usgs.gov/neis/epic/", "USGS National Earthquake Information Center: http://neic.usgs.gov/neis/epic/", "USGS National Earthquake Information Center: http://neic.usgs.gov/neis/epic/"};
    public static final String[][] searchDefaults = new String[][]{{"5.0", "9.9"}, {"1.0", "9.9"}, {"1.0", "9.9"}};
    protected static final Date maxEndDate = new Date();
    public int searchTypeIndex = 0;
    public String startingYear = "";
    public String startingMonth = "";
    public String startingDay = "";
    public String endingYear = "";
    public String endingMonth = "";
    public String endingDay = "";
    public String minimumDepth = "";
    public String maximumDepth = "";
    public String minimumMagnitude = "";
    public String maximumMagnitude = "";
    public String minimumIntensity = "";
    public String maximumIntensity = "";
    public String minimumLatitude = "";
    public String maximumLatitude = "";
    public String minimumLongitude = "";
    public String maximumLongitude = "";
    public String centerLatitude = "";
    public String centerLongitude = "";
    public String centerRadius = "";
    public String lastErrorString = "";

    public EventSearchParameters() {
    }

    public EventSearchParameters(EventSearchParameters eventSearchParameters) {
        this.searchTypeIndex = eventSearchParameters.searchTypeIndex;
        this.startingYear = eventSearchParameters.startingYear;
        this.startingMonth = eventSearchParameters.startingMonth;
        this.startingDay = eventSearchParameters.startingDay;
        this.endingYear = eventSearchParameters.endingYear;
        this.endingMonth = eventSearchParameters.endingMonth;
        this.endingDay = eventSearchParameters.endingDay;
        this.minimumDepth = eventSearchParameters.minimumDepth;
        this.maximumDepth = eventSearchParameters.maximumDepth;
        this.minimumMagnitude = eventSearchParameters.minimumMagnitude;
        this.maximumMagnitude = eventSearchParameters.maximumMagnitude;
        this.minimumIntensity = eventSearchParameters.minimumIntensity;
        this.maximumIntensity = eventSearchParameters.maximumIntensity;
        this.minimumLatitude = eventSearchParameters.minimumLatitude;
        this.maximumLatitude = eventSearchParameters.maximumLatitude;
        this.minimumLongitude = eventSearchParameters.minimumLongitude;
        this.maximumLongitude = eventSearchParameters.maximumLongitude;
        this.centerLatitude = eventSearchParameters.centerLatitude;
        this.centerLongitude = eventSearchParameters.centerLongitude;
        this.centerRadius = eventSearchParameters.centerRadius;
    }

    public EventSearchParameters(int n, int n2, int n3, int n4) {
        this.searchTypeIndex = n;
        this.setDates(n2, n3, n4);
    }

    public EventSearchParameters(int n, int n2, int n3, int n4, String string, String string2) {
        this.searchTypeIndex = n;
        this.setDates(n2, n3, n4);
        this.setMagnitudes(string, string2);
    }

    public EventSearchParameters(String[] stringArray) throws EventSearchException {
        this.searchTypeIndex = this.toSearchTypeIndex(stringArray[0]);
        if (this.searchTypeIndex < 0) {
            throw new EventSearchException("ERROR: unrecognized event search type name: " + stringArray[0]);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = Integer.valueOf(stringArray[1]);
            if (n3 < 1) {
                throw new EventSearchException("ERROR: invalid search duration days: " + n3);
            }
        }
        catch (Exception exception) {
            n3 = 60;
        }
        this.setDates(n, n2, n3);
        this.setMagnitudes(searchDefaults[this.searchTypeIndex][0], searchDefaults[this.searchTypeIndex][1]);
    }

    public void setDates(int n, int n2, int n3) {
        Date date = new Date();
        long l = 86400000L * ((long)n3 + (long)(30.4 * (double)n2) + (long)(365.25 * (double)n));
        Date date2 = new Date(date.getTime() - l);
        this.startingYear = "" + (date2.getYear() + 1900);
        this.startingMonth = "" + (date2.getMonth() + 1);
        this.startingDay = "" + date2.getDate();
        this.endingYear = "" + (date.getYear() + 1900);
        this.endingMonth = "" + (date.getMonth() + 1);
        this.endingDay = "" + date.getDate();
    }

    public void setMagnitudes(String string, String string2) {
        this.minimumMagnitude = string;
        this.maximumMagnitude = string2;
    }

    public int toSearchTypeIndex(String string) {
        for (int i = 0; i < searchTypeName.length; ++i) {
            if (searchTypeName[i].toUpperCase().indexOf(string.toUpperCase()) < 0) continue;
            return i;
        }
        return -1;
    }

    public String generateURLRequestString() throws Exception {
        Object object;
        Object object2;
        URL uRL = null;
        String[][] stringArray = null;
        if (this.searchTypeIndex == 0 || this.searchTypeIndex == 1 || this.searchTypeIndex == 2) {
            object2 = "1";
            if (!(this.minimumLatitude.trim().equals("") || this.minimumLongitude.trim().equals("") || this.maximumLatitude.trim().equals("") || this.maximumLongitude.trim().equals(""))) {
                object2 = "2";
            }
            object = "6";
            if (searchTypeName[this.searchTypeIndex].equals("SEARCH_NEIC_SWE")) {
                object = "4";
            }
            String string = this.searchTypeIndex == 0 ? "HH" : (this.searchTypeIndex == 1 ? "PP" : "NO");
            uRL = new URL("http://neic.usgs.gov/cgi-bin/epic/epic.cgi");
            String[][] stringArrayArray = new String[][]{{"SEARCHMETHOD", "SEARCHMETHOD", object2}, {"FILEFORMAT", "FILEFORMAT", object}, {"SEARCHRANGE", "SEARCHRANGE", string}, {"Starting Year", "SYEAR", this.startingYear}, {"Starting Month", "SMONTH", this.startingMonth}, {"Starting Day", "SDAY", this.startingDay}, {"Ending Year", "EYEAR", this.endingYear}, {"Ending Month", "EMONTH", this.endingMonth}, {"Ending Day", "EDAY", this.endingDay}, {"Minimum Depth", "NDEP1", this.minimumDepth}, {"Maximum Depth", "NDEP2", this.maximumDepth}, {"Minimum Magnitude", "LMAG", this.minimumMagnitude}, {"Maximum Magnitude", "UMAG", this.maximumMagnitude}, {"Minimum Intensity", "IO1", this.minimumIntensity}, {"Maximum Intensity", "IO2", this.maximumIntensity}, {"Minimum Latitude", "SLAT1", this.minimumLatitude}, {"Maximum Latitude", "SLAT2", this.maximumLatitude}, {"Minimum Longitude", "SLON1", this.minimumLongitude}, {"Maximum Longitude", "SLON2", this.maximumLongitude}, {"Center Latitude", "CLAT", this.centerLatitude}, {"Center Longitude", "CLON", this.centerLongitude}, {"Center Radius", "CRAD", this.centerRadius}, {"SUBMIT", "SUBMIT", "Submit+Search"}};
            stringArray = stringArrayArray;
        }
        object2 = new CgiBinParameterSet(stringArray);
        object = new CgiBinRequest(uRL, (CgiBinParameterSet)object2);
        return ((CgiBinRequest)object).createURL().toString();
    }

    public boolean checkParameterValues() {
        if (!this.check(this.startingYear, -10000, maxEndDate.getYear() + 1900 + 1, SeisText.START_TIME + " " + SeisText.YEAR)) {
            return false;
        }
        if (!this.check(this.startingMonth, 1, 12, SeisText.START_TIME + " " + SeisText.MONTH)) {
            return false;
        }
        if (!this.check(this.startingDay, 1, 31, SeisText.START_TIME + " " + SeisText.DAY)) {
            return false;
        }
        if (!this.check(this.endingYear, 0, maxEndDate.getYear() + 1900 + 1, SeisText.END_TIME + " " + SeisText.YEAR)) {
            return false;
        }
        if (!this.check(this.endingMonth, 1, 12, SeisText.END_TIME + " " + SeisText.MONTH)) {
            return false;
        }
        if (!this.check(this.endingDay, 1, 31, SeisText.END_TIME + " " + SeisText.DAY)) {
            return false;
        }
        if (!this.check(this.minimumDepth, -10.0, 1000.0, SeisText.DEPTH + " " + SeisText.MIN)) {
            return false;
        }
        if (!this.check(this.maximumDepth, -10.0, 1000.0, SeisText.DEPTH + " " + SeisText.MAX)) {
            return false;
        }
        String[] stringArray = new String[]{this.minimumDepth, this.maximumDepth};
        String[] stringArray2 = new String[]{SeisText.DEPTH};
        if (!this.checkValuesEntered(stringArray, stringArray2)) {
            return false;
        }
        if (!this.check(this.minimumMagnitude, -10.0, 10.0, SeisText.MAGNITUDE + " " + SeisText.MIN)) {
            return false;
        }
        if (!this.check(this.maximumMagnitude, -10.0, 10.0, SeisText.MAGNITUDE + " " + SeisText.MAX)) {
            return false;
        }
        stringArray = new String[]{this.minimumMagnitude, this.maximumMagnitude};
        stringArray2 = new String[]{SeisText.MAGNITUDE};
        if (!this.checkValuesEntered(stringArray, stringArray2)) {
            return false;
        }
        if (!this.check(this.minimumLatitude, -90.0, 90.0, SeisText.LATITUDE + " " + SeisText.MIN)) {
            return false;
        }
        if (!this.check(this.maximumLatitude, -90.0, 90.0, SeisText.LATITUDE + " " + SeisText.MAX)) {
            return false;
        }
        if (!this.check(this.minimumLongitude, -180.0, 180.0, SeisText.LONGITUDE + " " + SeisText.MIN)) {
            return false;
        }
        if (!this.check(this.maximumLongitude, -180.0, 180.0, SeisText.LONGITUDE + " " + SeisText.MAX)) {
            return false;
        }
        stringArray = new String[]{this.minimumLatitude, this.maximumLatitude, this.minimumLongitude, this.maximumLongitude};
        stringArray2 = new String[]{SeisText.LATITUDE, SeisText.LONGITUDE};
        return this.checkValuesEntered(stringArray, stringArray2);
    }

    protected boolean check(String string, int n, int n2, String string2) {
        if (string.trim().equals("")) {
            return true;
        }
        try {
            int n3 = Integer.valueOf(string);
            if (n3 >= n && n3 <= n2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastErrorString = SeisText.INVALID_VALUE + " " + string2 + ": \"" + string + "\": (" + n + "," + n2 + ")";
        return false;
    }

    protected boolean check(String string, double d, double d2, String string2) {
        if (string.trim().equals("")) {
            return true;
        }
        try {
            double d3 = Double.valueOf(string);
            if (d3 >= d && d3 <= d2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastErrorString = SeisText.INVALID_VALUE + " " + string2 + ": \"" + string + "\": " + SeisText.VALID_RANGE + "(" + d + "," + d2 + ")";
        return false;
    }

    protected boolean checkValuesEntered(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("")) {
                bl2 = true;
                continue;
            }
            bl = false;
        }
        if (bl || !bl2) {
            return true;
        }
        String string = "";
        for (int i = 0; i < stringArray2.length - 1; ++i) {
            string = string + stringArray2[i] + ", ";
        }
        string = string + stringArray2[stringArray2.length - 1];
        this.lastErrorString = SeisText.INVALID_VALUE + " " + string + ": " + SeisText.ALL_NON_BLANK;
        return false;
    }
}

