/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import net.alomax.util.StringExt;

public class AJLFileFilter
extends FileFilter {
    public static String COMPRESSED_EXTENSIONS = "gz*GZ*zip*ZIP";
    protected static AJLFileFilter[] imageIOFileFilters = null;
    protected String name = null;
    protected String primaryExtension = null;
    protected String validExtensions = null;
    protected String description = null;
    protected boolean allowCompressed = false;
    protected boolean allowAnywhere = false;

    public static AJLFileFilter[] mergeFilters(AJLFileFilter[] aJLFileFilterArray, String string) {
        int n;
        if (string == null) {
            return aJLFileFilterArray;
        }
        String[] stringArray = StringExt.parse(string, ";");
        AJLFileFilter[] aJLFileFilterArray2 = new AJLFileFilter[stringArray.length + aJLFileFilterArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2 = StringExt.parse(stringArray[n], ",");
            aJLFileFilterArray2[n] = stringArray2.length > 1 ? new AJLFileFilter(null, stringArray2[0], stringArray2[1], true, true) : (stringArray2.length > 0 ? new AJLFileFilter(null, stringArray2[0], "???", true, true) : new AJLFileFilter(null, "ERROR", "???", true, true));
        }
        for (n = stringArray.length; n < stringArray.length + aJLFileFilterArray.length; ++n) {
            aJLFileFilterArray2[n] = aJLFileFilterArray[n - stringArray.length];
        }
        return aJLFileFilterArray2;
    }

    public AJLFileFilter(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.name = string;
        this.primaryExtension = string2;
        this.validExtensions = string3;
        this.description = string4;
        this.allowCompressed = bl;
        this.allowAnywhere = bl2;
        if (!bl2) {
            string3 = string3.toLowerCase();
        }
    }

    public AJLFileFilter(String string, String string2, String string3, boolean bl, boolean bl2) {
        this(null, string, string2, string3, bl, bl2);
    }

    public AJLFileFilter(String string, String string2, String string3, boolean bl) {
        this(null, string, string2, string3, bl, false);
    }

    public AJLFileFilter(String string, String string2, String string3, String string4, boolean bl) {
        this(string, string2, string3, string4, bl, false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.validExtensions == null) {
            return false;
        }
        if (this.allowAnywhere) {
            String string = file.getName();
            if (string != null) {
                return string.indexOf(this.validExtensions) >= 0;
            }
        } else {
            return this.isValidExtension(file);
        }
        return false;
    }

    public boolean isValidExtension(File file) {
        String string = this.getExtension(file);
        if (string != null) {
            return this.validExtensions.indexOf(string) >= 0;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        if (string == null) {
            return null;
        }
        if (this.allowCompressed && COMPRESSED_EXTENSIONS.indexOf(string) >= 0 && (n = (string2 = string2.substring(0, n)).lastIndexOf(46)) > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public String getPrimaryExtension() {
        return this.primaryExtension;
    }

    public File addExtensionAuto(File file) {
        if (this.primaryExtension == null || this.getExtension(file) != null) {
            return file;
        }
        return new File(file.getAbsolutePath() + "." + this.primaryExtension);
    }

    public static AJLFileFilter[] getImageIOFileFilters() {
        if (imageIOFileFilters == null) {
            int n;
            Object[] objectArray = ImageIO.getWriterFileSuffixes();
            imageIOFileFilters = new AJLFileFilter[objectArray.length];
            Arrays.sort(objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                if (((String)objectArray[n]).equalsIgnoreCase("png")) {
                    Object object = objectArray[n];
                    objectArray[n] = objectArray[0];
                    objectArray[0] = object;
                }
                ++n;
            }
            n = 0;
            for (Object object : objectArray) {
                AJLFileFilter.imageIOFileFilters[n++] = new AJLFileFilter((String)object, (String)object, ((String)object).toUpperCase() + " (*." + (String)object + ")", true);
            }
        }
        return imageIOFileFilters;
    }
}

